/*
 * Decompiled with CFR 0.152.
 */
package fwb;

import MGAM.BotMaster;
import MGAM.Movement;
import fwb.FWBUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class RandomMovement
extends Movement {
    static final int TIME_TO_RELOCATE = 20;
    private int timeSinceRelocation;
    Point2D.Double destination;

    public RandomMovement(BotMaster bot) {
        super(bot);
    }

    @Override
    public void initialize() {
        this.timeSinceRelocation = 20;
        this.destination = this.selectNewDestination();
    }

    @Override
    public void move() {
        ++this.timeSinceRelocation;
        this.bot.setMaxVelocity(Math.abs(this.bot.getTurnRemaining()) > 33.0 ? 0.0 : 8.0);
        if (this.timeSinceRelocation >= 20) {
            this.destination = this.selectNewDestination();
            Point2D.Double location = new Point2D.Double(this.bot.self.botInfo.dX, this.bot.self.botInfo.dY);
            double angle = Utils.normalRelativeAngle((double)(FWBUtils.absoluteBearing(location, this.destination) - this.bot.getHeadingRadians()));
            double turnAngle = Math.atan(Math.tan(angle));
            this.bot.setTurnRightRadians(turnAngle);
            this.bot.setAhead(location.distance(this.destination) * (double)(angle == turnAngle ? 1 : -1));
            this.timeSinceRelocation = 0;
        }
    }

    public Point2D.Double selectNewDestination() {
        return new Point2D.Double(Math.random() * BotMaster.battlefieldWidth, Math.random() * BotMaster.battlefieldHeight);
    }

    @Override
    public void onPaint(Graphics2D g) {
        g.setColor(new Color(0, 255, 0, 128));
        g.drawLine((int)this.bot.self.botInfo.dX, (int)this.bot.self.botInfo.dY, (int)this.destination.x, (int)this.destination.y);
    }
}

