/*
 * Decompiled with CFR 0.152.
 */
package spinnercat.mega;

import java.awt.geom.Point2D;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class EnemyBot {
    double bearing;
    double distance;
    double energy;
    double heading;
    double velocity;
    String name;
    double x;
    double y;
    Point2D.Double pos;
    double changeHeading;
    double oldEnergy;

    public void update(ScannedRobotEvent e, Robot robot) {
        this.oldEnergy = this.energy;
        this.bearing = e.getBearing();
        this.distance = e.getDistance();
        this.energy = e.getEnergy();
        this.changeHeading = e.getHeading() - this.heading;
        this.heading = e.getHeading();
        this.name = e.getName();
        this.velocity = e.getVelocity();
        double absBearingDeg = robot.getHeading() + this.bearing;
        if (absBearingDeg < 0.0) {
            absBearingDeg += 360.0;
        }
        this.x = robot.getX() + Math.sin(Math.toRadians(absBearingDeg)) * this.distance;
        this.y = robot.getY() + Math.cos(Math.toRadians(absBearingDeg)) * this.distance;
        this.pos = new Point2D.Double(this.x, this.y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setDistance(double d) {
        this.distance = d;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getChangeHeading() {
        return this.changeHeading;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getHeadingRadians() {
        return Math.toRadians(this.heading);
    }

    public EnemyBot clone() {
        EnemyBot en = new EnemyBot();
        en.bearing = this.bearing;
        en.distance = this.distance;
        en.energy = this.energy;
        en.changeHeading = this.changeHeading;
        en.heading = this.heading;
        en.name = this.name;
        en.velocity = this.velocity;
        en.x = this.x;
        en.y = this.y;
        en.pos = (Point2D.Double)this.pos.clone();
        return en;
    }

    public void setHeading(double angle) {
        this.heading = angle;
    }

    public String getName() {
        return this.name;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getBearingRadians() {
        return Math.toRadians(this.bearing);
    }
}

