/*
 * Decompiled with CFR 0.152.
 */
package spinnercat.mega;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.Robot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import spinnercat.mega.EnemyBot;
import spinnercat.mega.Wave;

public class Tardis
extends AdvancedRobot {
    public static int BINS = 47;
    public static int distFactors = 10;
    public static double[][] dangerValues = new double[13][BINS];
    public Point2D.Double myLocation;
    public Point2D.Double enemyLocation;
    public ArrayList enemyWaves = new ArrayList();
    public ArrayList surfDirections = new ArrayList();
    public ArrayList surfAbsBearings = new ArrayList();
    public static Rectangle2D.Double field;
    public static double WALL_STICK;
    public static double oppEnergy;
    static int[][][] GFStats;
    static double[] currentDangers;
    static ArrayList<Wave> waves;
    EnemyBot enemy = new EnemyBot();

    static {
        WALL_STICK = 160.0;
        oppEnergy = 100.0;
        GFStats = new int[13][34][31];
        waves = new ArrayList();
    }

    public void run() {
        field = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        while (true) {
            this.doGun();
            this.doMove();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.enemy.update(e, (Robot)this);
        double radarTurn = this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(2.0 * radarTurn)));
    }

    public void doGun() {
        double d;
        if (this.enemy == null) {
            return;
        }
        double firepower = 3.0;
        double eEnergy = this.enemy.getEnergy();
        if (d < 16.0) {
            firepower = (eEnergy + 2.0) / 6.0;
        }
        if (firepower > this.getEnergy()) {
            firepower = this.getEnergy() - 0.1;
        }
        if (firepower < 1.0) {
            firepower = 1.0;
        }
        if (eEnergy < 0.01) {
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.enemy.getBearingRadians() + this.getHeadingRadians() - this.getGunHeadingRadians())));
            this.setFire(0.1);
            return;
        }
        double enemyAbsoluteBearing = this.enemy.getBearingRadians() + this.getHeadingRadians();
        double enemyLatVel = this.enemy.getVelocity() * Math.sin(this.enemy.getHeadingRadians() - enemyAbsoluteBearing);
        this.out.println(this.enemy.getChangeHeading());
        int[] currentStats = GFStats[(int)(this.enemy.getDistance() / 100.0)][(int)(2.0 * (enemyLatVel + 8.0))];
        double absBearing = Utils.normalRelativeAngle((double)(this.getHeadingRadians() + this.enemy.getBearingRadians()));
        int direction = 1;
        if (this.enemy.getVelocity() != 0.0) {
            direction = Math.sin(Math.toRadians(this.enemy.getHeading()) - absBearing) * this.enemy.getVelocity() < 0.0 ? -1 : 1;
        }
        Wave newWave = new Wave(this.getX(), this.getY(), absBearing, firepower, this.getTime(), direction, currentStats, 1);
        int bestindex = 15;
        int i = 0;
        while (i < waves.size()) {
            Wave currentWave = waves.get(i);
            if (currentWave.checkHit(this.enemy.getX(), this.enemy.getY(), this.getTime())) {
                waves.remove(currentWave);
            }
            ++i;
        }
        i = 0;
        while (i < currentStats.length) {
            if (currentStats[bestindex] < currentStats[i]) {
                bestindex = i;
            }
            ++i;
        }
        double guessfactor = (double)(bestindex * 2) / (double)(currentStats.length - 1) - 1.0;
        double angleOffset = guessfactor / (double)direction * newWave.maxEscapeAngle();
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing + angleOffset - this.getGunHeadingRadians())));
        this.out.println(this.getGunTurnRemaining());
        if (this.getGunTurnRemaining() < 10.0 && this.setFireBullet(firepower) != null) {
            newWave.weight = 7;
        }
        waves.add(newWave);
    }

    public void doMove() {
        double enemyAbsoluteBearing = Math.PI * 2 - (this.enemy.getBearingRadians() + this.getHeadingRadians());
        double enemyLatVel = this.getVelocity() * Math.sin(this.getHeadingRadians() - enemyAbsoluteBearing);
        currentDangers = dangerValues[(int)(this.enemy.getDistance() / 100.0)];
        this.myLocation = new Point2D.Double(this.getX(), this.getY());
        double lateralV = this.getVelocity() * Math.sin(this.enemy.getBearingRadians());
        double absBearing = this.enemy.getBearingRadians() + this.getHeadingRadians();
        this.surfDirections.add(0, new Integer(lateralV >= 0.0 ? 1 : -1));
        this.surfAbsBearings.add(0, new Double(absBearing + Math.PI));
        double bulletPower = oppEnergy - this.enemy.getEnergy();
        oppEnergy = this.enemy.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this.surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = Tardis.bulletVelocity(bulletPower);
            ew.distanceTraveled = Tardis.bulletVelocity(bulletPower);
            ew.direction1 = (Integer)this.surfDirections.get(2);
            ew.directAngle = (Double)this.surfAbsBearings.get(2);
            ew.fireLocation = new Point2D.Double(this.enemy.x, this.enemy.y);
            this.enemyWaves.add(ew);
        }
        this.updateWaves();
        this.doSurfing();
    }

    public void updateWaves() {
        int x = 0;
        while (x < this.enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this.enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this.myLocation.distance(ew.fireLocation) + 50.0) {
                this.enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this.enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this.enemyWaves.get(x);
            double distance = this.myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity + 5.0 && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = Tardis.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / Tardis.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction1;
        return (int)Tardis.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = Tardis.getFactorIndex(ew, targetLocation);
        int d = (int)this.enemy.distance / 10;
        int x = 0;
        while (x < BINS) {
            int n = x;
            currentDangers[n] = currentDangers[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this.enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this.enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this.enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this.myLocation.distance(ew.fireLocation)) < 50.0 && Math.round(Tardis.bulletVelocity(e.getBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this.enemyWaves.remove(this.enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this.enemyWaves.isEmpty()) {
            Point2D.Double blastPoint = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this.enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this.enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - blastPoint.distance(ew.fireLocation)) < 50.0 && Math.round(Tardis.bulletVelocity(e.getHitBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, blastPoint);
                this.enemyWaves.remove(this.enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this.myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, Tardis.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + Tardis.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = Tardis.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = Tardis.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = Tardis.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return currentDangers[index];
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = Tardis.absoluteBearing(surfWave.fireLocation, this.myLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(this.myLocation, goAngle - (this.enemy.energy > this.getEnergy() + 5.0 ? 1.4 : 1.6), -1) : this.wallSmoothing(this.myLocation, goAngle + (this.enemy.energy > this.getEnergy() + 5.0 ? 1.4 : 1.6), 1);
        Tardis.setBackAsFront(this, goAngle);
    }

    public double wallSmoothing(Point2D.Double p, double startAngle, int orientation) {
        double angle = startAngle;
        double x = p.x;
        double y = p.y;
        double testX = x + Math.sin(angle += Math.PI * 4) * WALL_STICK;
        double testY = y + Math.cos(angle) * WALL_STICK;
        double wallDistanceX = Math.min(x - 18.0, this.getBattleFieldWidth() - x - 18.0);
        double wallDistanceY = Math.min(y - 18.0, this.getBattleFieldHeight() - y - 18.0);
        double testDistanceX = Math.min(testX - 18.0, this.getBattleFieldWidth() - testX - 18.0);
        double testDistanceY = Math.min(testY - 18.0, this.getBattleFieldHeight() - testY - 18.0);
        double adjacent = 0.0;
        int g = 0;
        while (!field.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += (double)orientation * (Math.abs(Math.acos(adjacent / WALL_STICK)) + 0.005)) * WALL_STICK;
            testY = y + Math.cos(angle) * WALL_STICK;
            testDistanceX = Math.min(testX - 18.0, this.getBattleFieldWidth() - testX - 18.0);
            testDistanceY = Math.min(testY - 18.0, this.getBattleFieldHeight() - testY - 18.0);
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction1;
    }
}

