/*
 * Decompiled with CFR 0.152.
 */
package pe;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import pe.EnemyStats;
import pe.EnhancedEnemy;
import pe.Guess;
import pe.VBullet;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SandboxLump
extends AdvancedRobot {
    static HashMap guessMapMelee;
    static HashMap guessMapDual;
    static int[] winStats;
    EnhancedEnemy target;
    final double PI = Math.PI;
    int direction;
    long nextTurn;
    double nextX;
    double nextY;
    double firePower;
    double guessFactor;
    int guessFactorIndex;
    HashMap guessMap;
    HashMap EnemyPositionMap;
    int thisBattleNum;
    double[][] guessFactors;
    double[] guessDist;
    int distIndex;
    double fireConst;
    double rollingAverage;
    double gradient;
    double boundaryMove;
    double boundaryFire;
    long leftRight;
    long leftRight2;
    String battleType;
    long idleFire;
    boolean gunPointingAtTarget;
    PrintStream log;
    double firedEnergy;
    double aquiredEnergy;
    int maxStorage;
    int totalBots;
    long lastGetTime;
    ArrayList vBullets;
    long timeAtHit;

    public void run() {
        EnemyStats lastBattledAgainst;
        this.target = new EnhancedEnemy();
        this.target.name = "";
        this.target.distance = 10000.0;
        this.target.energy = 200.0;
        this.totalBots = this.getOthers();
        this.setColors(Color.pink, Color.pink, Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarLeftRadians(Math.PI * 2);
        this.battleType = this.getOthers() > 1 ? "Melee" : "Dual";
        if (guessMapMelee == null || guessMapDual == null) {
            guessMapMelee = (HashMap)this.PEreadObject("MeleeGuessMap");
            if (guessMapMelee == null) {
                guessMapMelee = new HashMap();
            }
            if ((guessMapDual = (HashMap)this.PEreadObject("DualGuessMap")) == null) {
                guessMapDual = new HashMap();
            }
        }
        this.guessMap = this.battleType == "Melee" ? guessMapMelee : guessMapDual;
        this.thisBattleNum = this.guessMap.size() == 0 ? 1 : ((lastBattledAgainst = (EnemyStats)Collections.max(this.guessMap.values())) != null ? lastBattledAgainst.lastBattleNum + 1 : 1);
        this.nextX = this.getX();
        this.nextY = this.getY();
        this.nextTurn = 10L;
        while (true) {
            double range;
            this.lastGetTime = this.getTime();
            if (this.getOthers() < 2) {
                range = this.totalBots == 1 ? 1100.0 : (this.totalBots < 4 ? 1000.0 : 900.0);
                this.boundaryMove = 50.0;
            } else {
                range = 800.0;
                if (this.getOthers() < 4) {
                    range = 1150.0;
                }
                this.boundaryMove = 50.0 + (double)(10L * (this.getTime() % (long)3));
            }
            this.fireConst = 6.666666666666667;
            this.gradient = range / this.fireConst;
            this.doMovement();
            this.doScanner();
            this.doVirtualBullets();
            if (!this.target.name.equals("")) {
                this.doGun();
                this.idleFire = this.getGunHeat() == 0.0 ? ++this.idleFire : 0L;
                if (this.getGunHeat() == 0.0 && this.firePower >= 0.1 && this.target.lockedOn && this.gunPointingAtTarget && this.firePower < this.getEnergy() - 1.5) {
                    String tName = this.target.name;
                    this.setFire(this.firePower);
                    this.firedEnergy += this.firePower;
                    int i = 0;
                    while (i < 11) {
                        double absBearing = this.absbearing(this.getX(), this.getY(), this.maxmin(this.getBattleFieldWidth() - this.boundaryFire, this.boundaryFire, this.target.guessX(this.timeAtHit, this.guessFactors[this.distIndex][i])), this.maxmin(this.getBattleFieldHeight() - this.boundaryFire, this.boundaryFire, this.target.guessY(this.timeAtHit, this.guessFactors[this.distIndex][i])));
                        if (this.vBullets.size() < 99) {
                            this.vBullets.add(new VBullet(tName, i, this.distIndex, this.getX(), this.getY(), absBearing, this.getTime(), this.firePower));
                        }
                        ++i;
                    }
                } else if (this.getGunHeat() == 0.0 && this.target.energy == 0.0 && this.gunPointingAtTarget) {
                    this.setFire(0.1);
                    this.firedEnergy += 0.1;
                } else if (this.idleFire > 10L && this.getEnergy() > (double)2 || this.idleFire > 100L && this.getEnergy() > 0.4) {
                    this.setFire(0.1);
                    this.firedEnergy += 0.1;
                }
            }
            this.target.lockedOn = false;
            this.execute();
        }
    }

    void doVirtualBullets() {
        long now = this.getTime();
        if (this.vBullets.size() == 0) {
            return;
        }
        Iterator m = this.vBullets.iterator();
        while (m.hasNext()) {
            EnemyStats stats;
            VBullet vBullet = (VBullet)m.next();
            String bulletTarget = vBullet.targetName;
            EnhancedEnemy thisEnemy = (EnhancedEnemy)this.EnemyPositionMap.get(bulletTarget);
            if (thisEnemy == null) {
                m.remove();
                continue;
            }
            if (vBullet.targetWasHit(thisEnemy.guessX(now, 1.0), thisEnemy.guessY(now, 1.0), now)) {
                stats = (EnemyStats)this.guessMap.get(bulletTarget);
                if (stats == null) {
                    this.out.println("could not get stats on bullet " + bulletTarget);
                } else {
                    stats.stats[vBullet.distanceIndex][vBullet.guessIndex].rollingAvg(1.0, this.rollingAverage, vBullet.power);
                }
                m.remove();
                continue;
            }
            if (!vBullet.outOfRange(thisEnemy.guessX(now, 1.0), thisEnemy.guessY(now, 1.0), now)) continue;
            stats = (EnemyStats)this.guessMap.get(bulletTarget);
            if (stats == null) {
                this.out.println("could not get stats on bullet " + bulletTarget);
            } else {
                stats.stats[vBullet.distanceIndex][vBullet.guessIndex].rollingAvg(0.0, this.rollingAverage, vBullet.power);
            }
            m.remove();
        }
    }

    void doMovement() {
        double distance = this.target.name.equals("") ? 500.0 : this.target.distance;
        if (this.getTime() >= this.nextTurn || this.target.gunFiredAtMe && distance < 350.0) {
            if (this.getOthers() > 1 && this.getrange(this.getX(), this.getY(), 0.0, 0.0) < 350.0 && distance > 100.0) {
                this.cornerMove(50.0, 50.0, 50.0, 50.0, (int)(this.getTime() / 11L) % 16);
            } else if (this.getOthers() > 1 && this.getrange(this.getX(), this.getY(), this.getBattleFieldWidth(), 0.0) < 350.0 && distance > 100.0) {
                this.cornerMove(this.getBattleFieldWidth() - 50.0, 50.0, -50.0, 50.0, (int)(this.getTime() / 11L) % 16);
            } else if (this.getOthers() > 1 && this.getrange(this.getX(), this.getY(), 0.0, this.getBattleFieldHeight()) < 350.0 && distance > 100.0) {
                this.cornerMove(50.0, this.getBattleFieldHeight() - 50.0, 50.0, -50.0, (int)(this.getTime() / 11L) % 16);
            } else if (this.getOthers() > 1 && this.getrange(this.getX(), this.getY(), this.getBattleFieldWidth(), this.getBattleFieldHeight()) < 350.0 && distance > 100.0) {
                this.cornerMove(this.getBattleFieldWidth() - 50.0, this.getBattleFieldHeight() - 50.0, -50.0, -50.0, (int)(this.getTime() / 11L) % 16);
            } else if (this.getOthers() > 1 && distance > 100.0) {
                this.antiGrav();
            } else {
                this.dualMove(distance);
            }
        }
        this.target.gunFiredAtMe = false;
        double reqOffset = this.getHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.nextX, this.nextY);
        if (this.direction == 1) {
            reqOffset += Math.PI;
        }
        if (Math.abs(reqOffset = this.NormaliseBearing(reqOffset)) > 1.5707963267948966) {
            reqOffset += Math.PI;
            this.direction = this.direction == 1 ? 0 : 1;
        }
        this.setTurnLeftRadians(this.NormaliseBearing(reqOffset));
        if (this.getOthers() >= 99) {
            if (this.direction == 0) {
                this.setAhead(1000.0);
            } else {
                this.setAhead(-1000.0);
            }
        } else if (this.direction == 0) {
            this.setAhead(this.getrange(this.getX(), this.getY(), this.nextX, this.nextY));
        } else {
            this.setAhead(-this.getrange(this.getX(), this.getY(), this.nextX, this.nextY));
        }
        if (Math.abs(this.getTurnRemaining()) > 65.0) {
            this.setAhead(0.0);
        }
        if (this.getrange(this.getX(), this.getY(), this.nextX, this.nextY) < 1.0 || this.getrange(this.getX(), this.getY(), this.nextX, this.nextY) < 10.0 && distance > 350.0) {
            this.setAhead(0.0);
            this.setTurnLeftRadians(0.0);
        }
    }

    void dualMove(double distance) {
        double travelModifier;
        if (distance < 100.0) {
            this.leftRight *= Math.round(Math.random() - 0.25) * (long)2 - 1L;
            travelModifier = 0.2;
        } else if (distance < 200.0) {
            this.leftRight *= Math.round(Math.random() + 0.0) * (long)2 - 1L;
            travelModifier = 0.2;
        } else if (distance < 300.0) {
            this.leftRight *= Math.round(Math.random() + 0.1) * (long)2 - 1L;
            travelModifier = 0.2;
        } else if (distance < 500.0) {
            this.leftRight *= Math.round(Math.random() + 0.2) * (long)2 - 1L;
            travelModifier = 0.1;
        } else {
            this.leftRight *= Math.round(Math.random() + 0.3) * (long)2 - 1L;
            travelModifier = -0.05;
        }
        if (Math.random() < 0.05) {
            this.leftRight *= Math.round(Math.random() - 0.25) * (long)2 - 1L;
            travelModifier = 1.0;
        }
        this.nextTurn = 9L + (long)(Math.random() * 8.0 + distance / 100.0);
        this.nextTurn += this.getTime();
        double targetDirection = this.absbearing(this.getX(), this.getY(), this.target.x, this.target.y);
        double newDirection = Math.PI / (distance / 175.0 + 1.0);
        newDirection = this.maxmin(2.0943951023931953, 1.0471975511965976, newDirection);
        newDirection *= (double)this.leftRight;
        this.nextX = this.maxmin(this.getBattleFieldWidth() - this.boundaryMove, this.boundaryMove, this.getX() + Math.sin(newDirection += targetDirection) * (15.0 + distance / 100.0) * 8.0 * (Math.random() + travelModifier), true);
        this.nextY = this.maxmin(this.getBattleFieldHeight() - this.boundaryMove, this.boundaryMove, this.getY() + Math.cos(newDirection) * (15.0 + distance / 100.0) * 8.0 * (Math.random() + travelModifier), true);
    }

    void antiGrav() {
        double bestG = Double.MAX_VALUE;
        double bestAngle = 0.0;
        double power = 2;
        this.nextTurn = this.getTime() + 6L;
        this.leftRight *= Math.round(Math.random() + 0.0) * (long)2 - 1L;
        double testAngle = Math.toRadians(5);
        while (testAngle < Math.PI * 2) {
            double testG = 0.0;
            double adjustAngle = -15.0;
            while (adjustAngle < 15.1) {
                double distance;
                double testX = this.getX() + Math.sin(testAngle + Math.toRadians(adjustAngle)) * 8.0 * (double)(this.nextTurn - this.getTime());
                double testY = this.getY() + Math.cos(testAngle + Math.toRadians(adjustAngle)) * 8.0 * (double)(this.nextTurn - this.getTime());
                Iterator m = this.EnemyPositionMap.keySet().iterator();
                while (m.hasNext()) {
                    String robotName = (String)m.next();
                    EnhancedEnemy testEnemy = (EnhancedEnemy)this.EnemyPositionMap.get(robotName);
                    double targetX = this.maxmin(this.getBattleFieldWidth() - this.boundaryMove, this.boundaryMove, testEnemy.guessX(this.getTime() + 8L, 1.0));
                    double targetY = this.maxmin(this.getBattleFieldHeight() - this.boundaryMove, this.boundaryMove, testEnemy.guessY(this.getTime() + 8L, 1.0));
                    distance = this.getrange(testX, testY, targetX, targetY);
                    testG += 1.0 / Math.pow(distance, power);
                }
                double fakeBotWeighting = 1.0;
                distance = this.getrange(testX, testY, this.getBattleFieldWidth() / (double)2, -100.0);
                testG += fakeBotWeighting / Math.pow(distance, power);
                distance = this.getrange(testX, testY, this.getBattleFieldWidth() / (double)2, this.getBattleFieldHeight() + 100.0);
                testG += fakeBotWeighting / Math.pow(distance, power);
                distance = this.getrange(testX, testY, -100.0, this.getBattleFieldHeight() / (double)2);
                testG += fakeBotWeighting / Math.pow(distance, power);
                distance = this.getrange(testX, testY, this.getBattleFieldWidth() + 100.0, this.getBattleFieldHeight() / (double)2);
                testG += fakeBotWeighting / Math.pow(distance, power);
                distance = this.getrange(testX, testY, this.getBattleFieldWidth() / (double)2, this.getBattleFieldHeight() / (double)2);
                testG += fakeBotWeighting / Math.pow(distance, power);
                adjustAngle += 30.0;
            }
            if (testG < bestG) {
                bestG = testG;
                bestAngle = testAngle;
            }
            testAngle += Math.toRadians(10.0);
        }
        this.nextX = this.maxmin(this.getBattleFieldWidth() - this.boundaryMove, this.boundaryMove, this.getX() + Math.sin(bestAngle + Math.toRadians((double)this.leftRight * 15.0)) * 8.0 * (double)(this.nextTurn - this.getTime()) * 1.5, true);
        this.nextY = this.maxmin(this.getBattleFieldHeight() - this.boundaryMove, this.boundaryMove, this.getY() + Math.cos(bestAngle + Math.toRadians((double)this.leftRight * 15.0)) * 8.0 * (double)(this.nextTurn - this.getTime()) * 1.5, true);
    }

    void cornerMove(double originX, double originY, double factorX, double factorY, int moveNum) {
        double[][] dArrayArray = new double[16][];
        dArrayArray[0] = new double[]{1.0, 1.0};
        double[] dArray = new double[2];
        dArray[0] = 2;
        dArrayArray[1] = dArray;
        dArrayArray[2] = new double[]{3, 1.0};
        double[] dArray2 = new double[2];
        dArray2[0] = 4;
        dArrayArray[3] = dArray2;
        double[] dArray3 = new double[2];
        dArray3[0] = 5;
        dArrayArray[4] = dArray3;
        double[] dArray4 = new double[2];
        dArray4[0] = 4;
        dArrayArray[5] = dArray4;
        dArrayArray[6] = new double[]{3, 1.0};
        double[] dArray5 = new double[2];
        dArray5[0] = 2;
        dArrayArray[7] = dArray5;
        dArrayArray[8] = new double[]{1.0, 1.0};
        double[] dArray6 = new double[2];
        dArray6[1] = 2;
        dArrayArray[9] = dArray6;
        dArrayArray[10] = new double[]{1.0, 3};
        double[] dArray7 = new double[2];
        dArray7[1] = 4;
        dArrayArray[11] = dArray7;
        double[] dArray8 = new double[2];
        dArray8[1] = 5;
        dArrayArray[12] = dArray8;
        double[] dArray9 = new double[2];
        dArray9[1] = 4;
        dArrayArray[13] = dArray9;
        dArrayArray[14] = new double[]{1.0, 3};
        double[] dArray10 = new double[2];
        dArray10[1] = 2;
        dArrayArray[15] = dArray10;
        double[][] moves = dArrayArray;
        this.nextTurn = this.getTime() + 11L;
        this.nextX = originX + moves[moveNum][0] * factorX;
        this.nextY = originY + moves[moveNum][1] * factorY;
    }

    void doScanner() {
        double radarOffset;
        radarOffset = this.getTime() - this.target.ctime > (long)4 || this.target.name.equals("") || this.getGunHeat() > 0.5 && this.getOthers() >= 2 ? 1.5707963267948966 : ((radarOffset = this.NormaliseBearing(this.getRadarHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.target.x, this.target.y))) < 0.0 ? (radarOffset -= 0.3141592653589793) : (radarOffset += 0.3141592653589793));
        this.setTurnRadarLeftRadians(this.NormaliseBearing(radarOffset));
    }

    void doGun() {
        this.doGuessFactor();
        long time = this.doFirePower(this.getTime());
        int i = 2;
        while (i < 5) {
            time = this.doFirePower(time);
            ++i;
        }
        double gunOffset = this.getGunHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.maxmin(this.getBattleFieldWidth() - this.boundaryFire, this.boundaryFire, this.target.guessX(time, this.guessFactor)), this.maxmin(this.getBattleFieldHeight() - this.boundaryFire, this.boundaryFire, this.target.guessY(time, this.guessFactor)));
        gunOffset = this.NormaliseBearing(gunOffset);
        this.setTurnGunLeftRadians(gunOffset);
        if (gunOffset < 0.39269908169872414 && this.getTime() % (long)3 == 0L) {
            gunOffset = 0.0;
        }
        this.gunPointingAtTarget = Math.abs(gunOffset) / (double)2 / Math.PI * 360.0 < (double)2 + 200.0 / this.target.distance;
        this.timeAtHit = time;
    }

    long doFirePower(long time) {
        this.firePower = this.maxmin(Math.min((double)3, this.getEnergy() / (double)5), 0.0, -this.getrange(this.getX(), this.getY(), this.target.guessX(time, this.guessFactor), this.target.guessY(time, this.guessFactor)) / this.gradient + this.fireConst);
        if (this.target.energy < 10.5) {
            this.firePower = Math.min(this.target.energy / 3.5, this.firePower);
        }
        if (this.firePower < 0.1 && this.firePower > 0.0) {
            this.firePower = 0.1;
        }
        if (this.getEnergy() < 6.0 && this.getOthers() > 1) {
            this.firePower = 0.0;
        }
        return this.getTime() + (long)(this.getrange(this.getX(), this.getY(), this.maxmin(this.getBattleFieldWidth() - this.boundaryFire, this.boundaryFire, this.target.guessX(time, this.guessFactor)), this.maxmin(this.getBattleFieldHeight() - this.boundaryFire, this.boundaryFire, this.target.guessY(time, this.guessFactor))) / (20.0 - (double)3 * this.firePower));
    }

    public void doGuessFactor() {
        EnemyStats stats = (EnemyStats)this.guessMap.get(this.target.name);
        if (stats == null) {
            this.guessFactorIndex = 5;
            this.distIndex = 3;
            this.guessFactor = this.guessFactors[this.distIndex][this.guessFactorIndex];
            return;
        }
        this.distIndex = 0;
        int j = 1;
        while (j < 4) {
            if (this.target.distance > this.guessDist[j - 1]) {
                this.distIndex = j;
            }
            ++j;
        }
        double maxValue = -0.0;
        int i = 0;
        while (i < 11) {
            if ((double)stats.stats[this.distIndex][i].value > maxValue) {
                this.guessFactorIndex = i;
                maxValue = stats.stats[this.distIndex][i].value;
            }
            ++i;
        }
        this.guessFactor = this.guessFactors[this.distIndex][this.guessFactorIndex];
    }

    double NormaliseBearing(double ang) {
        while (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        while (ang <= -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    double NormaliseHeading(double ang) {
        while (ang >= Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        while (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double getrange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        return Math.sqrt(xo * xo + yo * yo);
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        return Math.atan2(x2 - x1, y2 - y1);
    }

    public double maxmin(double maxval, double minval, double value, boolean reflect) {
        double newval = this.maxmin(maxval, minval, value);
        if (reflect && newval != value) {
            newval += newval - value;
        }
        return newval;
    }

    public double maxmin(double maxval, double minval, double value) {
        return Math.min(maxval, Math.max(minval, value));
    }

    public double randInRange(double value1, double value2) {
        return Math.random() * Math.abs(value1 - value2) + Math.min(value1, value2);
    }

    public double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public String filterFileName(String fileName) {
        String filtered = "";
        int i = 0;
        while (i < fileName.length()) {
            char c = fileName.charAt(i);
            filtered = Character.isLetterOrDigit(c) || c == '.' || c == '_' ? filtered + c : filtered + '_';
            ++i;
        }
        return filtered.toString();
    }

    public void writeFiles() {
        String robotName;
        EnemyStats stats;
        if (this.getRoundNum() + 1 == this.getNumRounds()) {
            this.trimGuessMap(guessMapMelee);
            this.PEWriteObject(guessMapMelee, "MeleeGuessMap");
            this.trimGuessMap(guessMapDual);
            this.PEWriteObject(guessMapDual, "DualGuessMap");
        }
        if (this.log != null && (stats = (EnemyStats)this.guessMap.get(robotName = this.target.name)) != null) {
            this.log.println("robot= " + this.filterFileName(robotName) + "   lastBattleNum= " + stats.lastBattleNum);
            if (stats.lastBattleNum == this.thisBattleNum) {
                int j = 0;
                while (j < 4) {
                    int i = 0;
                    while (i < 11) {
                        this.log.println("battleType= " + this.battleType + "   robot= " + this.filterFileName(robotName) + "   Dist= " + this.guessDist[j] + "   factor= " + this.guessFactors[j][i] + "   " + stats.stats[j][i]);
                        ++i;
                    }
                    ++j;
                }
            }
        }
        if (this.log != null) {
            this.log.close();
        }
    }

    public void trimGuessMap(HashMap guess) {
        while (this.PEZipSizeObject(guess) > this.maxStorage) {
            int oldestBattle = ((EnemyStats)Collections.min(guess.values())).lastBattleNum;
            Iterator m = guess.keySet().iterator();
            while (m.hasNext()) {
                String robotName = (String)m.next();
                int lastBattle = ((EnemyStats)guess.get((Object)robotName)).lastBattleNum;
                if (oldestBattle != lastBattle) continue;
                m.remove();
            }
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        EnemyStats scannedEnemyStats = (EnemyStats)this.guessMap.get(e.getName());
        if (scannedEnemyStats == null) {
            scannedEnemyStats = new EnemyStats();
            scannedEnemyStats.stats = this.initialiseStats();
            this.guessMap.put(e.getName(), scannedEnemyStats);
        }
        scannedEnemyStats.lastBattleNum = this.thisBattleNum;
        EnhancedEnemy scannedEnemyPos = (EnhancedEnemy)this.EnemyPositionMap.get(e.getName());
        if (scannedEnemyPos == null) {
            scannedEnemyPos = new EnhancedEnemy();
            this.EnemyPositionMap.put(e.getName(), scannedEnemyPos);
        }
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        scannedEnemyPos.gunFiredAtMe = false;
        if (this.getTime() - scannedEnemyPos.ctime == 1L) {
            scannedEnemyPos.diffhead = this.NormaliseBearing(e.getHeadingRadians() - scannedEnemyPos.head);
            scannedEnemyPos.diffspeed = e.getVelocity() - scannedEnemyPos.speed;
            scannedEnemyPos.lockedOn = true;
            if (scannedEnemyPos.energy - e.getEnergy() <= (double)3 && scannedEnemyPos.energy - e.getEnergy() >= 0.1) {
                scannedEnemyPos.gunFiredAtMe = true;
                scannedEnemyPos.gunFiredAtMeTime = this.getTime();
            }
        } else {
            scannedEnemyPos.diffspeed = 0.0;
            scannedEnemyPos.avgSpeed = 0.0;
            scannedEnemyPos.lockedOn = false;
        }
        if (this.getTime() - scannedEnemyPos.gunFiredAtMeTime > (long)3) {
            scannedEnemyPos.gunFiredAtMe = false;
        }
        scannedEnemyPos.name = e.getName();
        scannedEnemyPos.x = this.getX() + Math.sin(absbearing_rad) * e.getDistance();
        scannedEnemyPos.y = this.getY() + Math.cos(absbearing_rad) * e.getDistance();
        scannedEnemyPos.bearing = e.getBearingRadians();
        scannedEnemyPos.head = e.getHeadingRadians();
        scannedEnemyPos.ctime = this.getTime();
        scannedEnemyPos.speed = e.getVelocity();
        scannedEnemyPos.avgSpeed = this.rollingAvg(this.target.avgSpeed, this.target.speed, 16.0, 1.0);
        scannedEnemyPos.distance = e.getDistance();
        scannedEnemyPos.energy = e.getEnergy();
        if (this.getOthers() < 4 && e.getEnergy() < this.target.energy && this.getEnergy() < 10.0 && this.target.distance > 600.0) {
            this.target = scannedEnemyPos;
        } else if (this.target.name.equals("") || e.getDistance() < this.target.distance) {
            this.target = scannedEnemyPos;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        EnhancedEnemy deadEnemy = (EnhancedEnemy)this.EnemyPositionMap.get(e.getName());
        if (deadEnemy != null) {
            deadEnemy.name = "";
            deadEnemy.distance = 10000.0;
            deadEnemy.energy = 200.0;
            this.EnemyPositionMap.remove(e.getName());
        }
        if (this.getOthers() == 1) {
            EnemyStats lastBattledAgainst;
            this.battleType = "Dual";
            this.guessMap = guessMapDual;
            this.thisBattleNum = this.guessMap.size() == 0 ? 1 : ((lastBattledAgainst = (EnemyStats)Collections.max(this.guessMap.values())) != null ? lastBattledAgainst.lastBattleNum + 1 : 1);
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        if (e.isMyFault()) {
            this.nextTurn = this.getTime() + (long)5;
            this.nextX = this.maxmin(this.getBattleFieldWidth() - this.boundaryMove, this.boundaryMove, this.getX() + Math.sin(this.getHeading() + Math.PI * (double)(this.direction - 1)) * (double)5 * 8.0, true);
            this.nextY = this.maxmin(this.getBattleFieldHeight() - this.boundaryMove, this.boundaryMove, this.getY() + Math.cos(this.getHeading() + Math.PI * (double)(this.direction - 1)) * (double)5 * 8.0, true);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        Bullet b = e.getBullet();
        this.aquiredEnergy += b.getPower() * (double)3;
    }

    public void onWin(WinEvent e) {
        this.writeFiles();
        winStats[0] = winStats[0] + 1;
        int i = 0;
        while (i < Math.min(this.totalBots + 1, winStats.length)) {
            ++i;
        }
    }

    public void onDeath(DeathEvent e) {
        if (this.getOthers() != 0) {
            this.writeFiles();
            int n = Math.min(this.getOthers(), winStats.length - 1);
            winStats[n] = winStats[n] + 1;
            int i = 0;
            while (i < Math.min(this.totalBots + 1, winStats.length)) {
                ++i;
            }
        }
        this.out.println(this.getOthers() + " opponents remain");
    }

    public void onHitWall(HitWallEvent e) {
        this.nextTurn = this.getTime() + (long)5;
        this.nextX = this.maxmin(this.getBattleFieldWidth() - this.boundaryMove, this.boundaryMove, this.getX() + Math.sin(this.getHeading() + Math.PI * (double)(this.direction - 1)) * (double)5 * 8.0, true);
        this.nextY = this.maxmin(this.getBattleFieldHeight() - this.boundaryMove, this.boundaryMove, this.getY() + Math.cos(this.getHeading() + Math.PI * (double)(this.direction - 1)) * (double)5 * 8.0, true);
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
    }

    public Guess[][] initialiseStats() {
        Guess[][] stats = new Guess[4][11];
        int i = 0;
        while (i < 11) {
            stats[0][i] = this.battleType.equals("Melee") ? new Guess(i, 0.37) : new Guess(i, 0.25);
            stats[1][i] = this.battleType.equals("Melee") ? new Guess(i, 0.23) : new Guess(i, 0.19);
            stats[2][i] = this.battleType.equals("Melee") ? new Guess(i, 0.19) : new Guess(i, 0.18);
            stats[3][i] = this.battleType.equals("Melee") ? new Guess(i, 0.19) : new Guess(i, 0.18);
            int j = 0;
            while (j < 3) {
                if (this.guessFactors[j][i] <= 0.8 && this.guessFactors[j][i] >= 0.4) {
                    stats[j][i].value = (float)((double)stats[j][i].value + 0.02);
                }
                ++j;
            }
            if (this.guessFactors[3][i] <= 0.2 && this.guessFactors[3][i] >= -0.2) {
                stats[3][i].value = (float)((double)stats[3][i].value + 0.02);
            }
            ++i;
        }
        return stats;
    }

    public Object PEreadObject(String fileName) {
        Object o;
        try {
            ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(this.getDataFile(fileName + ".zobj"))));
            o = ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            o = null;
            this.out.println("IOException trying to read: " + e);
        }
        catch (ClassNotFoundException e) {
            o = null;
            this.out.println("error reading object from file: " + fileName + "   exception: " + e);
        }
        return o;
    }

    public void PEWriteObject(Object o, String fileName) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(fileName + ".zobj"))));
            oos.writeObject(o);
            oos.close();
        }
        catch (IOException e) {
            this.out.println("IOException trying to write: " + e);
        }
    }

    public int PEZipSizeObject(Object o) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(100000);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(baos));
            oos.writeObject(o);
            oos.close();
        }
        catch (IOException e) {
            this.out.println("IOException trying to write: " + e);
        }
        return baos.size();
    }

    private final /* synthetic */ void this() {
        this.PI = Math.PI;
        this.direction = 0;
        this.guessFactor = 0.7;
        this.guessFactorIndex = 0;
        this.EnemyPositionMap = new HashMap();
        double[][] dArrayArray = new double[4][];
        double[] dArray = new double[11];
        dArray[0] = 1.0;
        dArray[1] = 0.8;
        dArray[2] = 0.6;
        dArray[3] = 0.4;
        dArray[4] = 0.2;
        dArray[6] = -0.2;
        dArray[7] = -0.4;
        dArray[8] = -0.6;
        dArray[9] = -0.8;
        dArray[10] = -1.0;
        dArrayArray[0] = dArray;
        double[] dArray2 = new double[11];
        dArray2[0] = 1.0;
        dArray2[1] = 0.8;
        dArray2[2] = 0.6;
        dArray2[3] = 0.4;
        dArray2[4] = 0.2;
        dArray2[6] = -0.2;
        dArray2[7] = -0.4;
        dArray2[8] = -0.6;
        dArray2[9] = -0.8;
        dArray2[10] = -1.0;
        dArrayArray[1] = dArray2;
        double[] dArray3 = new double[11];
        dArray3[0] = 1.0;
        dArray3[1] = 0.8;
        dArray3[2] = 0.6;
        dArray3[3] = 0.4;
        dArray3[4] = 0.2;
        dArray3[6] = -0.2;
        dArray3[7] = -0.4;
        dArray3[8] = -0.6;
        dArray3[9] = -0.8;
        dArray3[10] = -1.0;
        dArrayArray[2] = dArray3;
        double[] dArray4 = new double[11];
        dArray4[0] = 1.0;
        dArray4[1] = 0.8;
        dArray4[2] = 0.6;
        dArray4[3] = 0.4;
        dArray4[4] = 0.2;
        dArray4[6] = -0.2;
        dArray4[7] = -0.4;
        dArray4[8] = -0.6;
        dArray4[9] = -0.8;
        dArray4[10] = -1.0;
        dArrayArray[3] = dArray4;
        this.guessFactors = dArrayArray;
        this.guessDist = new double[]{218.0, 306.0, 500.0, 10000.0};
        this.distIndex = 0;
        this.fireConst = 8.0;
        this.rollingAverage = 200.0;
        this.gradient = 100.0;
        this.boundaryFire = 50.0;
        this.leftRight = 1L;
        this.leftRight2 = 1L;
        this.gunPointingAtTarget = false;
        this.firedEnergy = 0.0;
        this.aquiredEnergy = 0.0;
        this.maxStorage = 40000;
        this.lastGetTime = 0L;
        this.vBullets = new ArrayList(100);
    }

    public SandboxLump() {
        this.this();
    }

    static {
        winStats = new int[100];
    }
}

