/*
 * Decompiled with CFR 0.152.
 */
package eem.gun;

import eem.EvBot;
import eem.gun.baseGun;
import eem.gun.circularGun;
import eem.gun.guessFactorGun;
import eem.gun.linearGun;
import eem.gun.pifGun;
import eem.misc.logger;
import eem.misc.math;
import eem.target.InfoBot;
import java.util.HashMap;
import java.util.LinkedList;

public class gunManager {
    public EvBot myBot;
    public static HashMap<String, LinkedList<baseGun>> gunSets = new HashMap();
    public static HashMap<String, baseGun> allUsedByMyBotGuns = new HashMap();
    private int numOfAllowedTicsInGunColdState = 5;

    public gunManager(EvBot evBot) {
        this.myBot = evBot;
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<Object> linkedList2 = new LinkedList<baseGun>();
        linkedList2.add(new circularGun(this.myBot));
        linkedList2.add(new guessFactorGun(this.myBot));
        linkedList2.add(new baseGun(this.myBot));
        linkedList2.add(new pifGun(this.myBot, 4));
        linkedList2.add(new pifGun(this.myBot, 20));
        String string = "1on1";
        gunSets.put(string, linkedList2);
        linkedList.add(string);
        linkedList2 = new LinkedList();
        linkedList2.add(new circularGun(this.myBot));
        linkedList2.add(new guessFactorGun(this.myBot));
        string = "melee1on1";
        gunSets.put(string, linkedList2);
        linkedList.add(string);
        linkedList2 = new LinkedList();
        linkedList2.add(new circularGun(this.myBot));
        string = "meleeMidle";
        gunSets.put(string, linkedList2);
        linkedList.add(string);
        linkedList2 = new LinkedList();
        linkedList2.add(new circularGun(this.myBot));
        string = "melee";
        gunSets.put(string, linkedList2);
        linkedList.add(string);
        linkedList2 = new LinkedList();
        linkedList2.add(new linearGun(this.myBot));
        linkedList2.add(new circularGun(this.myBot));
        linkedList2.add(new baseGun(this.myBot));
        gunSets.put("firingAtMyBot_in_melee", linkedList2);
        linkedList2 = new LinkedList();
        linkedList2.add(new linearGun(this.myBot));
        linkedList2.add(new circularGun(this.myBot));
        linkedList2.add(new baseGun(this.myBot));
        gunSets.put("firingAtMyBot_in_meleeMidle", linkedList2);
        linkedList2 = new LinkedList();
        linkedList2.add(new linearGun(this.myBot));
        linkedList2.add(new circularGun(this.myBot));
        linkedList2.add(new baseGun(this.myBot));
        linkedList2.add(new guessFactorGun(this.myBot));
        linkedList2.add(new pifGun(this.myBot));
        gunSets.put("firingAtMyBot_in_melee1on1", linkedList2);
        gunSets.put("firingAtMyBot_in_1on1", linkedList2);
        linkedList2 = new LinkedList();
        linkedList2.add(new linearGun(this.myBot));
        linkedList2.add(new circularGun(this.myBot));
        linkedList2.add(new baseGun(this.myBot));
        gunSets.put("firingAtMyBot_in_default", linkedList2);
        linkedList2 = new LinkedList();
        linkedList2.add(new circularGun(this.myBot));
        string = "defaultGun";
        gunSets.put(string, linkedList2);
        linkedList.add(string);
        for (String string2 : linkedList) {
            linkedList2 = gunSets.get(string2);
            for (baseGun baseGun2 : linkedList2) {
                allUsedByMyBotGuns.put(baseGun2.getName(), baseGun2);
            }
        }
    }

    public double overallGunsHitRate() {
        int n = 0;
        int n2 = 0;
        for (baseGun baseGun2 : allUsedByMyBotGuns.values()) {
            n += this.totalGunFiredCount(baseGun2);
            n2 += this.totalGunHitCount(baseGun2);
        }
        double d = math.eventRate(n2, n);
        return d;
    }

    public double getGunWeightForBot(baseGun baseGun2, InfoBot infoBot) {
        double d = 0.0;
        double d2 = 0.0;
        LinkedList<baseGun> linkedList = gunSets.get(this.myBot.fightType());
        for (baseGun baseGun3 : linkedList) {
            d2 = baseGun3.getGunVirtPerformance(infoBot);
            logger.noise("Gun[" + baseGun3.getName() + " ] performance = " + d2);
            d += d2;
        }
        d2 = baseGun2.getGunVirtPerformance(infoBot);
        double d3 = d2 / d;
        logger.noise("Gun[" + baseGun2.getName() + " ] weight = " + logger.shortFormatDouble(d3));
        return d3;
    }

    public baseGun getDefaultGun() {
        LinkedList<Object> linkedList = new LinkedList();
        linkedList = gunSets.get("defaultGun");
        return (baseGun)linkedList.getFirst();
    }

    public baseGun weights2gunForBot(InfoBot infoBot, String string) {
        baseGun baseGun2 = null;
        double d = Math.random();
        double d2 = 0.0;
        boolean bl = false;
        LinkedList<baseGun> linkedList = gunSets.get(string);
        LinkedList<Double> linkedList2 = new LinkedList<Double>();
        for (baseGun baseGun3 : linkedList) {
            linkedList2.add(this.getGunWeightForBot(baseGun3, infoBot));
        }
        int n = math.binNumByMaxWeight(linkedList2);
        baseGun2 = linkedList.get(n);
        return baseGun2;
    }

    public baseGun weights2gunForBot(InfoBot infoBot) {
        return this.weights2gunForBot(infoBot, this.myBot.fightType());
    }

    public baseGun choseGun() {
        baseGun baseGun2 = this.myBot.getGun();
        baseGun baseGun3 = null;
        boolean bl = false;
        if (baseGun2.isGunFired()) {
            bl = true;
        }
        if (baseGun2.getNumTicsInColdState() > this.numOfAllowedTicsInGunColdState) {
            bl = true;
            logger.noise("At tic: " + this.myBot.ticTime + " gun " + baseGun2.getName() + " is cold for too long: " + baseGun2.getNumTicsInColdState());
        }
        if (bl) {
            baseGun2.gunFired = false;
            logger.noise("new choice of gun instead of old " + baseGun2.getName());
            baseGun3 = this.weights2gunForBot(this.myBot._trgt);
            if (baseGun3 == null) {
                logger.warning("This should not happen: we did not chose a gun");
                baseGun3 = this.getDefaultGun();
            }
            if (!baseGun2.getName().equals(baseGun3.getName())) {
                baseGun2 = baseGun3;
                baseGun2.resetTicsInColdState();
            }
            logger.noise("Gun choice = " + baseGun2.getName());
        }
        baseGun2.setTargetFuturePosition(this.myBot._trgt);
        return baseGun2;
    }

    public int totalBotHitCount(InfoBot infoBot) {
        LinkedList<baseGun> linkedList = gunSets.get(this.myBot.fightType());
        int n = 0;
        for (baseGun baseGun2 : linkedList) {
            n += baseGun2.getBulletVirtHitCount(infoBot);
        }
        return n;
    }

    public int totalBotFiredCount(InfoBot infoBot) {
        LinkedList<baseGun> linkedList = gunSets.get(this.myBot.fightType());
        int n = 0;
        for (baseGun baseGun2 : linkedList) {
            n += baseGun2.getBulletVirtFiredCount(infoBot);
        }
        return n;
    }

    public double botAsTargetWeight(InfoBot infoBot) {
        LinkedList<InfoBot> linkedList = this.myBot._botsmanager.listOfAliveBots();
        boolean bl = true;
        for (InfoBot infoBot2 : linkedList) {
            if (!infoBot.getName().equals(infoBot2.getName())) continue;
            bl = false;
            break;
        }
        if (bl) {
            return 0.0;
        }
        double d = 0.0;
        for (InfoBot infoBot3 : linkedList) {
            d += math.perfRate(this.totalBotHitCount(infoBot3), this.totalBotFiredCount(infoBot3));
        }
        return math.perfRate(this.totalBotHitCount(infoBot), this.totalBotFiredCount(infoBot)) / d;
    }

    public InfoBot theBestTarget() {
        LinkedList<InfoBot> linkedList = this.myBot._botsmanager.listOfAliveBots();
        InfoBot infoBot = null;
        if (linkedList.size() == 0) {
            return infoBot;
        }
        double d = -10.0;
        for (InfoBot infoBot2 : linkedList) {
            double d2 = this.botAsTargetWeight(infoBot2);
            if (!(d2 > d)) continue;
            infoBot = infoBot2;
            d = d2;
        }
        return infoBot;
    }

    public int totalGunHitCount(baseGun baseGun2) {
        LinkedList<InfoBot> linkedList = this.myBot._botsmanager.listOfKnownBots();
        int n = 0;
        for (InfoBot infoBot : linkedList) {
            n += baseGun2.getBulletRealHitCount(infoBot);
        }
        return n;
    }

    public int totalGunFiredCount(baseGun baseGun2) {
        LinkedList<InfoBot> linkedList = this.myBot._botsmanager.listOfKnownBots();
        int n = 0;
        for (InfoBot infoBot : linkedList) {
            n += baseGun2.getBulletRealFiredCount(infoBot);
        }
        return n;
    }

    public void printGunsStatsForTarget(InfoBot infoBot) {
        logger.routine("----------------");
        logger.routine("Against bot: " + infoBot.getName());
        logger.routine("----------------");
        boolean bl = false;
        boolean bl2 = false;
        LinkedList<baseGun> linkedList = gunSets.get(this.myBot.fightType());
        LinkedList<String> linkedList2 = new LinkedList<String>();
        for (baseGun object : linkedList) {
            linkedList2.add(object.getName());
        }
        boolean bl3 = true;
        for (baseGun baseGun2 : allUsedByMyBotGuns.values()) {
            if (bl3) {
                bl3 = false;
                String string4 = "";
                string4 = string4 + baseGun2.gunStatsHeader(EvBot._tracker, infoBot);
                string4 = string4 + " | ";
                string4 = string4 + String.format("%9s", "gun weight");
                logger.routine(string4);
                logger.routine("------------------------------------------------------------");
            }
            String string = baseGun2.getName();
            String string5 = "";
            string5 = string5 + baseGun2.gunStatsFormat(EvBot._tracker, infoBot);
            string5 = string5 + " | ";
            if (linkedList2.contains(string)) {
                double d = this.getGunWeightForBot(baseGun2, infoBot);
                String string6 = logger.shortFormatDouble(d);
                string5 = string5 + string6;
            }
            logger.routine(string5);
        }
        logger.routine("---");
        double d = math.eventRate(this.totalBotHitCount(infoBot), this.totalBotFiredCount(infoBot));
        logger.routine(logger.shortFormatDouble(d) + " probability to hit bot " + infoBot.getName());
        logger.routine(logger.shortFormatDouble(this.botAsTargetWeight(infoBot)) + " weight as a target of bot " + infoBot.getName());
        logger.routine("Guess Factors: [ " + EvBot._tracker.guessFactorBins2string(infoBot) + "]");
    }

    public void printGunsStatsForBotsList(LinkedList<InfoBot> linkedList) {
        for (InfoBot infoBot : linkedList) {
            this.printGunsStatsForTarget(infoBot);
        }
    }

    public void printGunsStatsTicRelated() {
        logger.routine("-------------------------------------------------------");
        logger.routine("Fight type: " + this.myBot.fightType());
        LinkedList<InfoBot> linkedList = this.myBot._botsmanager.listOfDeadBots();
        if (linkedList.size() >= 1) {
            logger.routine("------ Gun Stats for Dead  bots ------------------------");
            this.printGunsStatsForBotsList(this.myBot._botsmanager.listOfDeadBots());
        }
        if ((linkedList = this.myBot._botsmanager.listOfAliveBots()).size() >= 1) {
            logger.routine("------ Gun Stats for Alive bots ------------------------");
            this.printGunsStatsForBotsList(this.myBot._botsmanager.listOfAliveBots());
        }
        this.printGunsBestTarget();
    }

    public void printGunsBestTarget() {
        logger.routine("-------------------------------------------------------");
        String string = this.theBestTarget() == null ? "Yet to find" : this.theBestTarget().getName();
        logger.routine(" ==> Overall best target: " + string);
    }

    public void printGunsStats() {
        LinkedList<InfoBot> linkedList = this.myBot._botsmanager.listOfKnownBots();
        int n = 0;
        logger.routine("-------------------------------------------------------");
        logger.routine("Gun stats for " + this.myBot.getName());
        logger.routine("-------------------------------------------------------");
        if (linkedList.size() >= 1) {
            logger.routine("------ Gun Stats for Dead  bots ------------------------");
            this.printGunsStatsForBotsList(this.myBot._botsmanager.listOfDeadBots());
            logger.routine("------ Gun Stats for Alive bots ------------------------");
            this.printGunsStatsForBotsList(this.myBot._botsmanager.listOfAliveBots());
        }
        logger.routine("------------------------------------------------------------");
        logger.routine("Summary for each of my guns at this stage across this game");
        logger.routine("------------------------------------------------------------");
        for (baseGun baseGun2 : allUsedByMyBotGuns.values()) {
            for (InfoBot object2 : linkedList) {
                n += baseGun2.getBulletRealFiredCount(object2);
            }
        }
        Object object = "";
        object = (String)object + String.format("%12s", "gun name");
        object = (String)object + " | ";
        object = (String)object + String.format("%20s", "Real gun hit rate");
        object = (String)object + " | ";
        object = (String)object + String.format("%20s", "firing rate");
        logger.routine((String)object);
        logger.routine("------------------------------------------------------------");
        for (baseGun baseGun2 : allUsedByMyBotGuns.values()) {
            String string = "";
            string = string + String.format("%12s", baseGun2.getName());
            int n2 = this.totalGunHitCount(baseGun2);
            int n3 = this.totalGunFiredCount(baseGun2);
            string = string + " | " + logger.hitRateFormat(n2, n3);
            string = string + " | " + logger.hitRateFormat(n3, n);
            logger.routine(string);
        }
        logger.routine("-------------------------------------------------------");
        logger.routine("Overall virtual guns hit rate = " + logger.shortFormatDouble(100.0 * this.overallGunsHitRate()) + "%");
        logger.routine("Overall real guns hit rate " + EvBot.bulletHitCnt + "/" + EvBot.bulletFiredCnt + " = " + logger.shortFormatDouble(100.0 * (double)EvBot.bulletHitCnt / (double)EvBot.bulletFiredCnt) + "%");
        logger.routine("I was hit by predicted bullet " + EvBot.bulletHitByPredictedCnt);
        logger.routine("-------------------------------------------------------");
    }
}

