/*
 * Decompiled with CFR 0.152.
 */
package kenran.offense;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import kenran.Bakko;
import kenran.defense.MovementDeque;
import kenran.util.MovementState;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class WarAxe {
    private static final int MAX_RECORD_LENGTH = 3000;
    private static final int RECENT_PATTERN_LENGTH = 12;
    private static final int MINIMUM_NUMBER_OF_RECORDS = 50;
    private static final double DEFAULT_BULLET_POWER = 1.9;
    private static final ArrayList<MovementState> _record = new ArrayList(3000);
    private final MovementDeque _recent = new MovementDeque(12);
    private double _enemyHeading = 0.0;
    private Bakko _bakko;

    public WarAxe(Bakko bakko) {
        this._bakko = bakko;
        for (int i = 0; i < this._recent.getMaxSize(); ++i) {
            this._recent.add(new MovementState(0.0, 8.0));
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double _deltaHeading = e.getHeadingRadians() - this._enemyHeading;
        this._enemyHeading = e.getHeadingRadians();
        this.record(_deltaHeading, e.getVelocity());
        double power = this.bulletPower(e.getEnergy(), e.getDistance());
        if (_record.size() > 50) {
            Point2D.Double predictedPosition = this.predictPosition(power);
            double predictedHeading = kenran.util.Utils.absoluteBearing(this._bakko.getPosition(), predictedPosition);
            this._bakko.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(predictedHeading - this._bakko.getGunHeadingRadians())));
        } else {
            double enemyBearing = this._bakko.getHeadingRadians() + e.getBearingRadians();
            this._bakko.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyBearing - this._bakko.getGunHeadingRadians())));
        }
        this._bakko.setFire(power);
    }

    private double bulletPower(double enemyEnergy, double distance) {
        if (enemyEnergy < 0.1) {
            return 0.1;
        }
        double power = distance < 150.0 ? 3.0 : 1.9;
        double powerToKill = enemyEnergy >= 16.0 ? (enemyEnergy + 2.0) / 6.0 : enemyEnergy / 4.0;
        power = Math.min(powerToKill, power);
        power = Math.max(0.1, power);
        power = Math.min(this._bakko.getEnergy(), power);
        return power;
    }

    private void record(double turnRate, double velocity) {
        MovementState ms = new MovementState(turnRate, velocity);
        this._recent.add(ms);
        _record.add(ms);
        if (_record.size() >= 3000) {
            _record.remove(0);
        }
    }

    private int lastIndexOfMatchingSeries() {
        MovementDeque iterator = new MovementDeque(12);
        for (int i = 0; i < iterator.getMaxSize(); ++i) {
            iterator.add(_record.get(i));
        }
        double minimumDistance = iterator.compare(this._recent);
        int indexOfMinimumDistance = this._recent.getMaxSize() - 1;
        int i = this._recent.getMaxSize();
        do {
            MovementState ms = _record.get(i);
            iterator.add(ms);
            double distance = iterator.compare(this._recent);
            if (!(distance <= minimumDistance)) continue;
            minimumDistance = distance;
            indexOfMinimumDistance = i;
        } while (++i < _record.size() - 50);
        return indexOfMinimumDistance;
    }

    private Point2D.Double predictPosition(double power) {
        int i = this.lastIndexOfMatchingSeries();
        Point2D.Double predictedPosition = (Point2D.Double)this._bakko.getEnemyPosition().clone();
        double heading = this._enemyHeading;
        double travelTime = 0.0;
        double turns = 0.0;
        for (int j = i + 1; j < _record.size() && turns <= travelTime; turns += 1.0, ++j) {
            MovementState ms = _record.get(j);
            predictedPosition.x += Math.sin(heading) * ms.getVelocity();
            predictedPosition.y += Math.cos(heading) * ms.getVelocity();
            heading += ms.getTurnRate();
            travelTime = kenran.util.Utils.bulletTravelTime(this._bakko.getPosition().distance(predictedPosition), power);
        }
        return predictedPosition;
    }
}

