/*
 * Decompiled with CFR 0.152.
 */
package xander.cat;

import java.awt.geom.Path2D;
import xander.cat.drive.GreenBeeSurfSelector;
import xander.cat.radar.BasicRadar;
import xander.core.AbstractXanderRobot;
import xander.core.ComponentChain;
import xander.core.Configuration;
import xander.core.drive.DistancingEquation;
import xander.core.drive.DriveBoundsFactory;
import xander.core.gun.Gun;
import xander.core.gun.GunArray;
import xander.core.gun.VirtualHitRatioGunSelector;
import xander.core.gun.XanderGun;
import xander.core.gun.power.FixedPowerSelector;
import xander.core.gun.power.PowerSelector;
import xander.gfws.data.DataPointFactorArrayProcessor;
import xander.gfws.data.FactorArrayParms;
import xander.gfws.data.KDTreeWaveLogger;
import xander.gfws.data.KNNLogReader;
import xander.gfws.data.KNNParms;
import xander.gfws.drive.DirectWaveSurfingDrive;
import xander.gfws.gun.targeter.GuessFactorTargeter;
import xander.gfws.modifier.LinearFactorArrayModifier;
import xander.gfws.processor.FAMFactorArrayProcessor;
import xander.gfws.segment.AttackerBearingSegmenter;
import xander.gfws.segment.BulletTravelTimeSegmenter;
import xander.gfws.segment.DefenderAccelerationSegmenter;
import xander.gfws.segment.DefenderSpeedSegmenter;
import xander.gfws.segment.WallStickSegmenter;

public class Fiona
extends AbstractXanderRobot {
    private static int gidx;

    private Gun createGun(KNNLogReader gunLogReader, FactorArrayParms gunFactorArrayParms, PowerSelector powerSelector) {
        DataPointFactorArrayProcessor gunFAP = new DataPointFactorArrayProcessor(gunLogReader, 91, gunFactorArrayParms);
        GuessFactorTargeter targeter = new GuessFactorTargeter(gunFAP);
        XanderGun gun = new XanderGun("GF Gun " + gidx, targeter, powerSelector);
        gun.setMinEnergyToFire(4.1);
        gun.setLowEnergyConservationRate(0.3333333333333333);
        ++gidx;
        return gun;
    }

    @Override
    protected void configure(Configuration configuration) {
        configuration.setRollingVirtualHitRatioDepth(50);
    }

    @Override
    protected void addComponents(ComponentChain chain) {
        chain.addDefaultComponents(new BasicRadar(45.0, 5.0));
        Path2D.Double driveBounds = DriveBoundsFactory.getSmoothedRectangleBounds(this.getBattleFieldSize());
        DistancingEquation de = new DistancingEquation(80.0, 400.0, 600.0, 75.0, 40.0);
        LinearFactorArrayModifier fam = new LinearFactorArrayModifier(3.0);
        FAMFactorArrayProcessor driveFAP = new FAMFactorArrayProcessor(false, 67, fam);
        GreenBeeSurfSelector surfSelector = new GreenBeeSurfSelector(driveFAP, de);
        DirectWaveSurfingDrive mainDrive = new DirectWaveSurfingDrive("AL Drive", surfSelector, driveBounds);
        chain.addDefaultComponents(mainDrive);
        FixedPowerSelector mainPowerSelector = new FixedPowerSelector(1.85);
        KDTreeWaveLogger gunWaveLogger = new KDTreeWaveLogger(true, new DefenderSpeedSegmenter(16), new BulletTravelTimeSegmenter(24, this.getBattleFieldSize()), new DefenderAccelerationSegmenter(), new AttackerBearingSegmenter(24), new WallStickSegmenter(4, 60.0, 260.0, true), new WallStickSegmenter(4, 60.0, 260.0, false));
        KNNParms gunKNNParms = new KNNParms(20, 100, 0.05);
        KNNLogReader gunLogReader = new KNNLogReader(gunWaveLogger, gunKNNParms);
        FactorArrayParms gunFactorArrayParms = new FactorArrayParms(true);
        Gun gun1 = this.createGun(gunLogReader, gunFactorArrayParms, mainPowerSelector);
        gunFactorArrayParms = new FactorArrayParms(true);
        gunFactorArrayParms.setVaryWeightByAge(0.002);
        Gun gun2 = this.createGun(gunLogReader, gunFactorArrayParms, mainPowerSelector);
        gunKNNParms = new KNNParms(1, 20, 0.01);
        gunLogReader = new KNNLogReader(gunWaveLogger, gunKNNParms);
        gunFactorArrayParms = new FactorArrayParms(true);
        Gun gun3 = this.createGun(gunLogReader, gunFactorArrayParms, mainPowerSelector);
        VirtualHitRatioGunSelector gunSelector = new VirtualHitRatioGunSelector();
        gunSelector.setRollingRatioWeight(0.7);
        GunArray gunArray = new GunArray(gunSelector, gun1, gun2, gun3);
        chain.addDefaultComponents(gunArray);
    }
}

