/*
 * Decompiled with CFR 0.152.
 */
package wcsv.mega;

import java.awt.Graphics;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import wcsv.mega.Location;
import wcsv.mega.Utils;

public class WaveBase {
    private Location center;
    private double initialBearing;
    private double velocity;
    private long startTime;

    public WaveBase(Location center, double initialBearing, double velocity, long startTime) {
        this.center = center.copy();
        this.initialBearing = initialBearing;
        this.velocity = velocity;
        this.startTime = startTime;
    }

    public WaveBase copy() {
        return new WaveBase(this.center, this.initialBearing, this.velocity, this.startTime);
    }

    public double bearingChange(Location loc) {
        return Utils.relAngle(this.center.absBearing(loc) - this.initialBearing);
    }

    public double distanceTo(Location loc, long time) {
        return this.center.distance(loc) - this.radius(time);
    }

    public double getVelocity() {
        return this.velocity;
    }

    public Location getCenter() {
        return this.center;
    }

    public void draw(Graphics g, long time) {
        double r = this.radius(time);
        g.drawOval((int)(this.center.getX() - r), (int)(this.center.getY() - r), (int)(2.0 * r), (int)(2.0 * r));
    }

    private double radius(long time) {
        return (double)(time - this.startTime) * this.velocity;
    }

    public static WaveBase closestWave(LinkedList waves, Location loc, long time) {
        int closest = -1;
        double closeDist = Double.MAX_VALUE;
        ListIterator it = waves.listIterator();
        while (it.hasNext()) {
            WaveBase wv = (WaveBase)it.next();
            double dist = Math.abs(wv.distanceTo(loc, time));
            if (!(dist < closeDist)) continue;
            closeDist = dist;
            closest = it.previousIndex();
        }
        return closest != -1 ? (WaveBase)waves.get(closest) : null;
    }

    public static WaveBase closestWave(LinkedList waves, Location loc, long time, double minDistance) {
        int closest = -1;
        double closeDist = Double.MAX_VALUE;
        ListIterator it = waves.listIterator();
        while (it.hasNext()) {
            WaveBase wv = (WaveBase)it.next();
            double dist = Math.abs(wv.distanceTo(loc, time));
            if (!(dist < closeDist) || !(dist > minDistance)) continue;
            closeDist = dist;
            closest = it.previousIndex();
        }
        return closest != -1 ? (WaveBase)waves.get(closest) : null;
    }

    public static LinkedList sortWaves(Location ref, long time, double minDist, LinkedList waves) {
        LinkedList<WaveBase> newList = new LinkedList<WaveBase>();
        ListIterator it = waves.listIterator();
        while (it.hasNext()) {
            WaveBase wv = (WaveBase)it.next();
            if (!(wv.distanceTo(ref, time) > minDist)) continue;
            newList.add(wv);
        }
        Collections.sort(newList, new WaveSorter(ref, time));
        return newList;
    }

    private static class WaveSorter
    implements Comparator {
        private Location ref;
        private long time;

        public WaveSorter(Location ref, long time) {
            this.ref = ref;
            this.time = time;
        }

        public int compare(Object o1, Object o2) {
            double d2;
            double d1 = ((WaveBase)o1).distanceTo(this.ref, this.time);
            if (d1 < (d2 = ((WaveBase)o2).distanceTo(this.ref, this.time))) {
                return -1;
            }
            if (d2 > d1) {
                return 1;
            }
            return 0;
        }
    }
}

