/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.morfeas;

import gre.svman4.useful.FieldPoint;
import gre.svman4.useful.RobotState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public abstract class Movement {
    public static double MAX_DISTANCE = 150.0;
    public static double MIN_ANGLE_TO_LOW_SPEED = 25.0;
    public static double SPEED_ON_ROBOT_TURN = 2.5;
    protected RobotState _mineRobot = new RobotState();
    protected double _movingAngle;
    protected Rectangle2D _movingPlace;
    protected FieldPoint _nextPosition = new FieldPoint();

    public Movement(RobotState me) {
        this._mineRobot = me;
    }

    public abstract Color getColor();

    public Color getColor(double lower, double val, double higher) {
        double range = higher - lower;
        double value = Math.min(range, Math.max(val - lower, 0.0));
        double H = (range - value) / range * 0.4;
        double S = 0.9;
        double B = 0.9;
        return Color.getHSBColor((float)H, (float)S, (float)B);
    }

    public abstract String getName();

    public FieldPoint getNextPosition() {
        return this._nextPosition;
    }

    public void goTo(double goAngle, double distance, AdvancedRobot robot) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(distance);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(distance);
        }
        this.speedLimit(robot);
    }

    protected void goTo(FieldPoint destination, AdvancedRobot robot) {
        double distance = this._mineRobot.distance(destination);
        this._movingAngle = Math.toRadians(this.normalRelativeAngle(Math.toDegrees(this._mineRobot.getAngleTo(destination)) - robot.getHeading()));
        this._movingAngle = this._mineRobot.getAngleTo(destination);
        this.goTo(this._movingAngle, distance, robot);
    }

    private double normalRelativeAngle(double angle) {
        angle = Math.toRadians(angle);
        return Math.toDegrees(Math.atan2(Math.sin(angle), Math.cos(angle)));
    }

    public void onPaint(Graphics2D g) {
        g.setColor(this.getColor(0.0, 8.0 - Math.abs(this._mineRobot.velocity), 8.0));
        double temp = Math.abs(this._mineRobot.velocity / 8.0) * 50.0;
        FieldPoint tempPoint = this._mineRobot.project(15.0 + temp, this._movingAngle);
        g.drawLine((int)this._mineRobot.x, (int)this._mineRobot.y, (int)tempPoint.x, (int)tempPoint.y);
        g.fillOval((int)(tempPoint.x - 1.5), (int)(tempPoint.y - 1.5), 3, 3);
    }

    public abstract void run(AdvancedRobot var1);

    public void setMe(RobotState me) {
        this._mineRobot = me;
    }

    protected void setMovingArea(Rectangle2D movingArea) {
        this._movingPlace = movingArea;
    }

    public void speedLimit(AdvancedRobot robot) {
        robot.setMaxVelocity(Math.abs(robot.getTurnRemainingRadians()) > MIN_ANGLE_TO_LOW_SPEED ? SPEED_ON_ROBOT_TURN : 8.0);
    }
}

