/*
 * Decompiled with CFR 0.152.
 */
package de.erdega.robocode.base;

import de.erdega.robocode.util.Vector;
import java.io.Serializable;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class AnalyzedScannedRobotEvent
implements Serializable {
    private static final long serialVersionUID = 7790950393433568443L;
    private transient ScannedRobotEvent _event;
    private String _enemyName;
    private double _enemyEnergy;
    private Vector _enemyBearing;
    private double _enemyRelativeBearingAngle;
    private Vector _enemyPosition;
    private Vector _enemyVelocity;
    private Vector _robotVelocity;
    private Vector _robotHeading;
    private double _robotGunHeading;
    private double _robotRadarHeading;
    private double _robotDistanceRemaining;
    private Vector _robotPosition;
    private double _robotEnergy;
    private long _time;

    public AnalyzedScannedRobotEvent(AdvancedRobot robot, ScannedRobotEvent event) {
        Vector robotPosition = new Vector(robot.getX(), robot.getY());
        double v = robot.getVelocity();
        v = Math.abs(v) < 1.0E-9 ? 1.0E-9 : v;
        this._robotVelocity = Vector.createPolarVector(v, robot.getHeadingRadians());
        this._robotHeading = Vector.createPolarVector(1.0, robot.getHeadingRadians());
        this._robotGunHeading = robot.getGunHeadingRadians();
        this._robotRadarHeading = robot.getRadarHeadingRadians();
        this._robotDistanceRemaining = robot.getDistanceRemaining();
        this._robotPosition = new Vector(robot.getX(), robot.getY());
        this._robotEnergy = robot.getEnergy();
        this._event = event;
        this._enemyName = event.getName();
        this._enemyEnergy = event.getEnergy();
        this._enemyRelativeBearingAngle = event.getBearingRadians();
        this._enemyBearing = Vector.createPolarVector(event.getDistance(), this._enemyRelativeBearingAngle + this._robotHeading.getPhi());
        this._enemyPosition = Vector.add(robotPosition, this._enemyBearing);
        double ev = event.getVelocity();
        ev = Math.abs(ev) < 1.0E-9 ? 1.0E-9 : ev;
        this._enemyVelocity = Vector.createPolarVector(ev, event.getHeadingRadians());
        this._time = event.getTime();
    }

    public ScannedRobotEvent getEvent() {
        return this._event;
    }

    public Vector getEnemyBearing() {
        return this._enemyBearing;
    }

    public Vector getEnemyPosition() {
        return this._enemyPosition;
    }

    public Vector getEnemyVelocity() {
        return this._enemyVelocity;
    }

    public double getEnemyRelativeBearingAngle() {
        return this._enemyRelativeBearingAngle;
    }

    public Vector getRobotVelocity() {
        return this._robotVelocity;
    }

    public double getRobotGunHeading() {
        return this._robotGunHeading;
    }

    public double getRobotRadarHeading() {
        return this._robotRadarHeading;
    }

    public double getRobotDistanceRemaining() {
        return this._robotDistanceRemaining;
    }

    public Vector getRobotPosition() {
        return this._robotPosition;
    }

    public Vector getRobotHeading() {
        return this._robotHeading;
    }

    public long getTime() {
        return this._time;
    }

    public String getEnemyName() {
        return this._enemyName;
    }

    public double getEnemyEnergy() {
        return this._enemyEnergy;
    }

    public double getRobotEnergy() {
        return this._robotEnergy;
    }
}

