/*
 * Decompiled with CFR 0.152.
 */
package rsalesc.roborio.utils.structures;

import rsalesc.roborio.utils.structures.KdTree;

public class WeightedManhattanKdTree<T>
extends KdTree<T> {
    private double[] weights;

    public WeightedManhattanKdTree(double[] dArray, Integer n) {
        super(dArray.length, n);
        this.weights = dArray;
    }

    @Override
    public int minkowskiBestHyperplane(KdTree<T> kdTree) {
        int n = 0;
        double d = (kdTree.max[0] - kdTree.min[0]) * this.weights[0];
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        for (int i = 1; i < kdTree.dim; ++i) {
            double d2 = (kdTree.max[i] - kdTree.min[i]) * this.weights[i];
            if (Double.isNaN(d2)) {
                d2 = 0.0;
            }
            if (!(d2 > d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    @Override
    public double minkowskiDistance(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            double d2 = Math.abs(dArray[i] - dArray2[i]) * this.weights[i];
            if (Double.isNaN(d2)) continue;
            d += d2;
        }
        return d;
    }

    @Override
    public double minkowskiToHyperrect(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray2 == null) {
            return Double.POSITIVE_INFINITY;
        }
        double d = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            double d2 = 0.0;
            if (dArray[i] > dArray3[i]) {
                d2 = (dArray[i] - dArray3[i]) * this.weights[i];
            }
            if (dArray[i] < dArray2[i]) {
                d2 = (dArray2[i] - dArray[i]) * this.weights[i];
            }
            if (Double.isNaN(d2)) continue;
            d += Math.abs(d2);
        }
        return d;
    }
}

