/*
 * Decompiled with CFR 0.152.
 */
package syl.util;

import java.io.Serializable;
import syl.util.Angle;

public class Coordinate
implements Cloneable,
Serializable {
    private double x;
    private double y;
    public static double BATTLEFIELD_HEIGHT = Double.MAX_VALUE;
    public static double BATTLEFIELD_WIDTH = Double.MAX_VALUE;
    public static Coordinate LOWER_LEFT;
    public static Coordinate UPPER_LEFT;
    public static Coordinate LOWER_RIGHT;
    public static Coordinate UPPER_RIGHT;

    public Coordinate(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static void initialize(double battleFieldWidth, double battleFieldHeight) {
        BATTLEFIELD_HEIGHT = battleFieldHeight;
        BATTLEFIELD_WIDTH = battleFieldWidth;
        LOWER_LEFT = new Coordinate(0.0, 0.0);
        UPPER_LEFT = new Coordinate(0.0, battleFieldHeight);
        LOWER_RIGHT = new Coordinate(battleFieldWidth, 0.0);
        UPPER_RIGHT = new Coordinate(battleFieldWidth, battleFieldHeight);
    }

    public static double getAngle(double x1, double y1, double x2, double y2) {
        double angle = Math.toDegrees(Math.atan2(y2 - y1, x2 - x1));
        return Angle.toAbsoluteAngle(90.0 - angle);
    }

    public double getAngle(double x2, double y2) {
        return Coordinate.getAngle(this.x, this.y, x2, y2);
    }

    public double getAngle(Coordinate coordinate) {
        return Coordinate.getAngle(this.x, this.y, coordinate.getX(), coordinate.getY());
    }

    public void move(double angle, double distance) {
        this.x += Math.sin(Math.toRadians(angle)) * distance;
        this.y += Math.cos(Math.toRadians(angle)) * distance;
    }

    public static Coordinate getCoordinate(double x, double y, double distance, double angle) {
        double newX = x + Math.sin(Math.toRadians(angle)) * distance;
        double newY = y + Math.cos(Math.toRadians(angle)) * distance;
        return new Coordinate(newX, newY);
    }

    public Coordinate getCoordinate(double distance, double angle) {
        return Coordinate.getCoordinate(this.getX(), this.getY(), distance, angle);
    }

    public static double getDistance(double x1, double y1, double x2, double y2) {
        double xo = x1 - x2;
        double yo = y1 - y2;
        return Math.sqrt(xo * xo + yo * yo);
    }

    public double getDistance(Coordinate coordinate) {
        return Coordinate.getDistance(this.x, this.y, coordinate.getX(), coordinate.getY());
    }

    public double getDistance(double x1, double y1) {
        return Coordinate.getDistance(this.x, this.y, x1, y1);
    }

    public boolean isValid() {
        if (this.x < 0.0) {
            return false;
        }
        if (this.y < 0.0) {
            return false;
        }
        if (this.x > BATTLEFIELD_WIDTH) {
            return false;
        }
        return !(this.y > BATTLEFIELD_HEIGHT);
    }

    public boolean equals(Object o) {
        Coordinate c;
        return o instanceof Coordinate && (c = (Coordinate)o).getX() - this.x < 1.0 && c.getY() - this.y < 1.0;
    }

    public boolean isNear(Coordinate coordinate, double distance) {
        return this.getDistance(coordinate) <= distance;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(").append(this.x).append(",").append(this.y).append(")");
        return sb.toString();
    }

    public Coordinate getClone() {
        try {
            return (Coordinate)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }
}

