/*
 * Decompiled with CFR 0.152.
 */
package syl.util.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import syl.util.pattern.PatternFinder;
import syl.util.pattern.SimplePatternFinder;

public class BoyerMoorePatternFinder
implements PatternFinder {
    private boolean useHashMap = false;

    public int[] findAll(ArrayList data, ArrayList pattern) {
        HashMap lastList = this.computeLastList(pattern);
        return this.boyerMoore(data, pattern, lastList, false);
    }

    public int findOne(ArrayList data, ArrayList pattern) {
        HashMap lastList = this.computeLastList(pattern);
        int[] result = this.boyerMoore(data, pattern, lastList, true);
        if (result.length == 0) {
            return -1;
        }
        return result[0];
    }

    private HashMap computeLastList(ArrayList pattern) {
        HashMap lastList = new HashMap();
        int i = 0;
        while (i < pattern.size()) {
            lastList.put(pattern.get(i), new Integer(i));
            ++i;
        }
        return lastList;
    }

    private int[] boyerMoore(ArrayList data, ArrayList pattern, HashMap lastList, boolean findOne) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int dataSize = data.size();
        int patternSize = pattern.size();
        int i = 0;
        while (i < dataSize - patternSize + 1) {
            Integer lastObject;
            int j = patternSize - 1;
            while (j >= 0 && pattern.get(j).equals(data.get(i + j))) {
                --j;
            }
            if (j < 0) {
                result.add(new Integer(i));
                if (findOne) break;
            }
            if ((lastObject = (Integer)lastList.get(data.get(i + j))) == null) {
                i += patternSize;
                continue;
            }
            int last = lastObject;
            i += Math.max(1, j - last);
        }
        int[] res = new int[result.size()];
        int k = 0;
        while (k < res.length) {
            res[k] = (Integer)result.get(k);
            ++k;
        }
        return res;
    }

    public static void main(String[] args) {
        ArrayList data = BoyerMoorePatternFinder.getSequence(50000, 30);
        ArrayList pattern = BoyerMoorePatternFinder.getSequence(10, 30);
        BoyerMoorePatternFinder patternFinder = new BoyerMoorePatternFinder();
        SimplePatternFinder simplePatternFinder = new SimplePatternFinder();
        System.out.println("Boyer-Moore pattern finder: ");
        long startTime = System.currentTimeMillis();
        int cycles = 1000;
        int[] result = null;
        int i = 0;
        while (i < cycles) {
            result = patternFinder.findAll(data, pattern);
            ++i;
        }
        long stopTime = System.currentTimeMillis();
        System.out.println("Time spend on " + cycles + " cycles: " + (stopTime - startTime));
        System.out.println(String.valueOf(result.length) + " patterns found.");
        System.out.println("Simple pattern finder: ");
        startTime = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < cycles) {
            result = simplePatternFinder.findAll(data, pattern);
            ++i2;
        }
        stopTime = System.currentTimeMillis();
        System.out.println("Time spend on " + cycles + " cycles: " + (stopTime - startTime));
        System.out.println(String.valueOf(result.length) + " patterns found.");
    }

    public static ArrayList getSequence(int size, int numberOfElements) {
        ArrayList<Integer> data = new ArrayList<Integer>();
        int i = 0;
        while (i < size) {
            Integer result = new Integer((int)Math.round(Math.random() * (double)numberOfElements));
            data.add(result);
            ++i;
        }
        return data;
    }
}

