/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.turning;

import benhorner.utility.turning.Variable;
import benhorner.utility.units.Bearing;
import benhorner.utility.units.Units;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualsHint {
    private Collection<Variable> sum;
    private Bearing equals_value;

    public EqualsHint(Collection<Variable> sum, Bearing equals_value) {
        this.sum = sum;
        this.equals_value = equals_value;
    }

    public boolean propagate() {
        boolean result;
        boolean propagating = result = this.propagationPass();
        while (propagating) {
            propagating = this.propagationPass();
        }
        return result;
    }

    public boolean propagationPass() {
        Bearing min_sum = new Bearing(0.0);
        Bearing max_sum = new Bearing(0.0);
        for (Variable v : this.sum) {
            min_sum = min_sum.add(v.getMin());
            max_sum = max_sum.add(v.getMax());
        }
        boolean result = false;
        for (Variable v : this.sum) {
            Bearing others_min_sum = min_sum.subtract(v.getMin());
            Bearing others_max_sum = max_sum.subtract(v.getMax());
            result = result || v.decreaseMaxTo(Units.max(v.getMin(), this.equals_value.subtract(others_min_sum)));
            boolean bl = result = result || v.increaseMinTo(Units.min(v.getMax(), this.equals_value.subtract(others_max_sum)));
        }
        return result;
    }

    public String toString() {
        return "sum(" + this.sum + ") == " + this.equals_value;
    }
}

