/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.units;

import benhorner.utility.units.interfaces.AbsoluteToRelative;
import benhorner.utility.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Duration
implements Continuum<Duration>,
AbsoluteToRelative<Duration, Duration> {
    private double turns;

    public Duration(double turns) {
        assert (!Double.isNaN(turns));
        this.turns = turns;
    }

    @Override
    public Duration negate() {
        return new Duration(-this.turns);
    }

    @Override
    public Duration add(Duration duration) {
        return new Duration(this.turns + duration.turns);
    }

    @Override
    public Duration add(double d) {
        return this.add(new Duration(d));
    }

    @Override
    public Duration subtract(Duration duration) {
        return new Duration(this.turns - duration.turns);
    }

    @Override
    public Duration multiply(double d) {
        return new Duration(this.turns * d);
    }

    @Override
    public Duration divide(double d) {
        return new Duration(this.turns / d);
    }

    @Override
    public double divide(Duration t) {
        return this.turns / t.turns;
    }

    @Override
    public double toDouble() {
        return this.turns;
    }

    public String toString() {
        return String.valueOf(Long.toString(Math.round(this.turns))) + "t";
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o.getClass() == this.getClass();
        if (result) {
            Duration d = (Duration)o;
            result = d.turns == this.turns;
        }
        return result;
    }

    public int hashCode() {
        return new Double(this.turns).hashCode();
    }
}

