/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.units;

import benhorner.utility.Rules;
import benhorner.utility.units.Bearing;
import benhorner.utility.units.Distance;
import benhorner.utility.units.Duration;
import benhorner.utility.units.interfaces.AbsoluteToRelative;
import benhorner.utility.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Speed
implements Continuum<Speed>,
AbsoluteToRelative<Speed, Speed> {
    private double pixels_per_turn;

    public Speed(double pixels_per_turn) {
        assert (!Double.isNaN(pixels_per_turn));
        this.pixels_per_turn = pixels_per_turn;
    }

    @Override
    public Speed negate() {
        return new Speed(-this.pixels_per_turn);
    }

    @Override
    public Speed add(Speed d) {
        return new Speed(this.pixels_per_turn + d.pixels_per_turn);
    }

    @Override
    public Speed subtract(Speed d) {
        return new Speed(this.pixels_per_turn - d.pixels_per_turn);
    }

    @Override
    public Speed multiply(double d) {
        return new Speed(this.pixels_per_turn * d);
    }

    public Distance multiply(Duration duration) {
        return new Distance(this.pixels_per_turn * duration.toDouble());
    }

    @Override
    public Speed divide(double d) {
        return new Speed(this.pixels_per_turn / d);
    }

    @Override
    public double divide(Speed speed) {
        return this.pixels_per_turn / speed.pixels_per_turn;
    }

    @Override
    public double toDouble() {
        return this.pixels_per_turn;
    }

    public Bearing getMaxTurn() {
        return Rules.ROBOT_TURN_RATE.subtract(0.75 * Math.abs(this.pixels_per_turn));
    }

    public String toString() {
        return String.valueOf(Long.toString(Math.round(this.pixels_per_turn))) + "ppt";
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o.getClass() == this.getClass();
        if (result) {
            Speed speed = (Speed)o;
            result = speed.pixels_per_turn == this.pixels_per_turn;
        }
        return result;
    }

    public int hashCode() {
        return new Double(this.pixels_per_turn).hashCode();
    }
}

