/*
 * Decompiled with CFR 0.152.
 */
package wcsv.melee;

import java.awt.geom.Point2D;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import wcsv.melee.Utils;

public class BasicInfo {
    public Point2D.Double location;
    public double energy;
    public double lastEnergy;
    public double velocity;
    public double lastVelocity;
    public double heading;
    public double damageDoneToMe;
    public double tempDamage;
    public String name;
    public long scanTime;
    public int readings;

    public void update(ScannedRobotEvent scan, TeamRobot observer) {
        this.name = scan.getName();
        this.lastVelocity = this.velocity;
        this.velocity = scan.getVelocity();
        this.lastEnergy = this.energy;
        this.energy = scan.getEnergy();
        this.heading = scan.getHeadingRadians();
        double tempBearing = Utils.absoluteAngle((observer.getHeadingRadians() + scan.getBearingRadians()) % (Math.PI * 2));
        this.location = Utils.projectPoint(observer.getX(), observer.getY(), tempBearing, scan.getDistance());
        this.scanTime = observer.getTime();
        this.damageDoneToMe = Utils.rollingAvg(this.damageDoneToMe, this.tempDamage, this.readings, 25.0);
        this.tempDamage = 1.0;
        ++this.readings;
    }

    public void update(TeamRobot robot) {
        this.name = robot.getName();
        this.lastVelocity = this.velocity;
        this.velocity = robot.getVelocity();
        this.lastEnergy = this.energy;
        this.energy = robot.getEnergy();
        this.heading = robot.getHeadingRadians();
        this.location.setLocation(robot.getX(), robot.getY());
        this.scanTime = robot.getTime();
        this.damageDoneToMe = Utils.rollingAvg(this.damageDoneToMe, this.tempDamage, this.readings, 25.0);
        this.tempDamage = 1.0;
        ++this.readings;
    }

    public BasicInfo(ScannedRobotEvent scan, TeamRobot observer) {
        this.name = scan.getName();
        this.lastVelocity = this.velocity = scan.getVelocity();
        this.lastEnergy = this.energy = scan.getEnergy();
        this.heading = scan.getHeadingRadians();
        double tempBearing = Utils.absoluteAngle((observer.getHeadingRadians() + scan.getBearingRadians()) % (Math.PI * 2));
        this.location = Utils.projectPoint(observer.getX(), observer.getY(), tempBearing, scan.getDistance());
        this.scanTime = observer.getTime();
        this.damageDoneToMe = 1.0;
        this.tempDamage = 1.0;
        this.readings = 1;
    }

    public BasicInfo(TeamRobot robot) {
        this.name = robot.getName();
        this.lastVelocity = this.velocity = robot.getVelocity();
        this.lastEnergy = this.energy = robot.getEnergy();
        this.heading = robot.getHeadingRadians();
        this.location = new Point2D.Double(robot.getX(), robot.getY());
        this.scanTime = robot.getTime();
        this.readings = 1;
        this.tempDamage = 1.0;
    }

    public BasicInfo(BasicInfo info) {
        this.name = new String(info.name);
        this.location = new Point2D.Double(info.location.getX(), info.location.getY());
        this.velocity = info.velocity;
        this.lastVelocity = info.lastVelocity;
        this.energy = info.energy;
        this.lastEnergy = info.lastEnergy;
        this.heading = info.heading;
        this.scanTime = info.scanTime;
        this.damageDoneToMe = info.damageDoneToMe;
        this.tempDamage = info.tempDamage;
        this.readings = info.readings;
    }
}

