/*
 * Decompiled with CFR 0.152.
 */
package wcsv.melee;

import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.ListIterator;
import wcsv.melee.Info;
import wcsv.melee.Utils;

public class Wave {
    public Info source;
    public Info target;
    public Info targetReference;
    public int startTime;
    public double velocity;
    public boolean isRealBullet;

    public double radius(int time) {
        return (double)(time - this.startTime) * this.velocity;
    }

    public double distanceToPoint(Point2D.Double loc, int time) {
        return Utils.distance(loc, this.source.basic.location) - this.radius(time);
    }

    public int timeToPoint(Point2D.Double loc, int time) {
        return (int)(this.distanceToPoint(loc, time) / this.velocity);
    }

    public double computeCentralBearingChange(Point2D.Double newLocation) {
        return Utils.relativeAngle(Utils.absoluteAngleToPoint(this.source.basic.location, newLocation) - Utils.absoluteAngleToPoint(this.source.basic.location, this.target.basic.location));
    }

    public double absoluteBearingFromSource(Point2D.Double newLocation) {
        return Utils.absoluteAngleToPoint(this.source.basic.location, newLocation);
    }

    public static Wave getClosestWave(Point2D.Double loc, LinkedList waves, int time) {
        ListIterator it = waves.listIterator();
        double closestDist = Double.MAX_VALUE;
        Wave w = null;
        Wave closest = null;
        while (it.hasNext()) {
            w = (Wave)it.next();
            double currDist = Math.abs(w.distanceToPoint(loc, time));
            if (!(currDist < closestDist)) continue;
            closest = w;
            closestDist = currDist;
        }
        return closest;
    }

    public Wave() {
    }

    public Wave(Info src, Info targ, double bulletPower, int time, boolean real) {
        this.source = new Info(src);
        this.target = new Info(targ);
        this.targetReference = targ;
        this.velocity = Utils.bulletPowerToVelocity(bulletPower);
        this.startTime = time;
        this.isRealBullet = real;
    }
}

