/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.mirror;

import xander.core.Resources;
import xander.core.RobotEvents;
import xander.core.drive.Direction;
import xander.core.event.RoundBeginListener;
import xander.core.event.TurnListener;

public class MirrorPlan
implements TurnListener,
RoundBeginListener {
    private int[] tickCounts = new int[20];
    private Direction direction = Direction.CLOCKWISE;
    private int timeIndex;
    private long time;
    private int reversalTickRange;

    public MirrorPlan(RobotEvents robotEvents, int reversalTickRange) {
        this.reversalTickRange = reversalTickRange;
        robotEvents.addTurnListener(this);
        robotEvents.addRoundBeginListener(this);
    }

    private void generateTickCount(int timeIndex) {
        this.tickCounts[timeIndex] = (int)Math.round(Math.random() * (double)this.reversalTickRange) + 5;
    }

    public Direction getDirection(long futureTime) {
        long timeCounter = futureTime - this.time;
        int index = this.timeIndex;
        Direction d = this.direction;
        while (timeCounter > 0L) {
            if ((timeCounter -= (long)this.tickCounts[index]) > 0L) {
                d = d.reverse();
            }
            if (++index != this.tickCounts.length) continue;
            index = 0;
        }
        return d;
    }

    @Override
    public void onRoundBegin() {
        int i = 0;
        while (i < this.tickCounts.length) {
            this.generateTickCount(i);
            ++i;
        }
        this.timeIndex = 0;
        this.time = Resources.getTime();
    }

    @Override
    public void onTurnBegin() {
        long currentTime = Resources.getTime();
        int elapsed = (int)(currentTime - this.time);
        while (elapsed > 0) {
            int reduce = Math.min(elapsed, this.tickCounts[this.timeIndex]);
            int n = this.timeIndex;
            this.tickCounts[n] = this.tickCounts[n] - reduce;
            if (this.tickCounts[this.timeIndex] == 0) {
                this.generateTickCount(this.timeIndex);
                ++this.timeIndex;
                this.direction = this.direction.reverse();
                if (this.timeIndex == this.tickCounts.length) {
                    this.timeIndex = 0;
                }
            }
            elapsed -= reduce;
        }
        this.time = currentTime;
    }

    @Override
    public void onTurnEnd() {
    }
}

