/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.ram;

import java.awt.geom.Rectangle2D;
import robocode.Bullet;
import robocode.HitByBulletEvent;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.drive.Direction;
import xander.core.drive.Drive;
import xander.core.drive.DriveController;
import xander.core.drive.OrbitalDrivePredictor;
import xander.core.event.OpponentWaveListener;
import xander.core.math.RCMath;
import xander.core.math.VelocityVector;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.core.track.WaveHistory;

public class RamEscapeDrive
implements Drive,
OpponentWaveListener {
    private RobotProxy robotProxy;
    private OrbitalDrivePredictor orbitalDriver = new OrbitalDrivePredictor();
    private WaveHistory waveHistory;
    private Rectangle2D.Double bb;
    private double baseTurn = 50.0;
    private double currentTurn;
    private Wave currentWave;
    private Wave turnWave;

    public RamEscapeDrive() {
        this.robotProxy = Resources.getRobotProxy();
        this.waveHistory = Resources.getWaveHistory();
        this.bb = this.robotProxy.getBattleFieldSize();
        this.waveHistory.addOpponentWaveListener(this);
    }

    @Override
    public String getName() {
        return "Ram Escape Drive";
    }

    @Override
    public void driveTo(Snapshot opponentSnapshot, DriveController driveController) {
        double x = this.robotProxy.getX();
        double y = this.robotProxy.getY();
        double awayAngle = RCMath.getRobocodeAngle(opponentSnapshot.getX(), opponentSnapshot.getY(), x, y);
        double currentAngle = this.robotProxy.getBackAsFrontHeadingDegrees();
        double driveAngle = awayAngle;
        if (Math.abs(RCMath.getTurnAngle(currentAngle, awayAngle)) < 90.0) {
            driveAngle = currentAngle;
        }
        if (this.waveHistory.getOpponentActiveWaveCount() != 0) {
            if (this.currentWave != this.turnWave) {
                boolean turnAwayViable;
                Direction orbitDirection = this.orbitalDriver.getOribitalDirection(this.bb.getCenterX(), this.bb.getCenterY());
                this.currentTurn = this.baseTurn * (double)orbitDirection.getDirectionUnit();
                boolean bl = turnAwayViable = RCMath.getDistanceToIntersect(x, y, currentAngle - (double)(90 * orbitDirection.getDirectionUnit()), this.bb) > 110.0;
                if (turnAwayViable) {
                    double headingToOpp = RCMath.normalizeDegrees(awayAngle + 180.0);
                    double oppBearing = RCMath.getTurnAngle(currentAngle, headingToOpp);
                    if (orbitDirection == Direction.CLOCKWISE && oppBearing > 90.0 && oppBearing < 145.0 || orbitDirection == Direction.COUNTER_CLOCKWISE && oppBearing > -145.0 && oppBearing < -90.0) {
                        this.currentTurn *= -1.0;
                    }
                }
                this.turnWave = this.currentWave;
            }
            driveAngle = RCMath.normalizeDegrees(driveAngle + this.currentTurn);
        }
        VelocityVector driveVector = this.orbitalDriver.getSmoothedOrbitAngle(driveAngle, 8.0);
        driveController.drive(driveVector.getRoboAngle(), driveVector.getMagnitude());
    }

    @Override
    public void drive(DriveController driveController) {
    }

    @Override
    public void onRoundBegin() {
        this.currentWave = null;
        this.turnWave = null;
    }

    @Override
    public void oppWaveCreated(Wave wave) {
    }

    @Override
    public void oppWaveHitBullet(Wave wave, Bullet oppBullet) {
    }

    @Override
    public void oppWaveHit(Wave wave) {
    }

    @Override
    public void oppNextWaveToHit(Wave wave) {
        this.currentWave = wave;
    }

    @Override
    public void oppBulletHit(Wave wave, HitByBulletEvent hitByBulletEvent) {
    }

    @Override
    public void oppWavePassing(Wave wave) {
    }

    @Override
    public void oppWavePassed(Wave wave) {
    }

    @Override
    public void oppWaveUpdated(Wave wave) {
    }

    @Override
    public void oppWaveDestroyed(Wave wave) {
    }
}

