/*
 * Decompiled with CFR 0.152.
 */
package xander.core.gun.detect;

import java.awt.geom.Point2D;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.event.MyWaveListener;
import xander.core.event.OpponentWaveListener;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;
import xander.core.track.XBulletWave;

public abstract class TargetingDetector
implements MyWaveListener,
OpponentWaveListener {
    protected RobotProxy robotProxy;
    protected SnapshotHistory snapshotHistory;
    private int hits;
    private int shots;
    private String name;
    private boolean offensive;

    public TargetingDetector(String name, boolean offensive) {
        this.name = name;
        this.offensive = offensive;
        if (offensive) {
            Resources.getWaveHistory().addMyWaveListener(this);
        } else {
            Resources.getWaveHistory().addOpponentWaveListener(this);
        }
        this.robotProxy = Resources.getRobotProxy();
        this.snapshotHistory = Resources.getSnapshotHistory();
    }

    public abstract double getDetectionAngle(Wave var1);

    protected abstract double getSloppyAimTolerance();

    public String getName() {
        return this.name;
    }

    public double getDetectionPercentage() {
        if (this.shots == 0) {
            return 0.0;
        }
        return (double)this.hits / (double)this.shots;
    }

    public int getShotsTested() {
        return this.shots;
    }

    @Override
    public void oppWaveCreated(Wave wave) {
    }

    @Override
    public void oppWaveHitBullet(Wave wave, Bullet oppBullet) {
    }

    @Override
    public void oppWaveHit(Wave wave) {
        if (!this.offensive) {
            double detectionAngle = this.getDetectionAngle(wave);
            double travelDistance = RCMath.getDistanceBetweenPoints(wave.getOriginX(), wave.getOriginY(), this.robotProxy.getX(), this.robotProxy.getY());
            Point2D.Double detectionPosition = RCMath.getLocation(wave.getOriginX(), wave.getOriginY(), travelDistance, detectionAngle);
            double difference = RCMath.getDistanceBetweenPoints(detectionPosition.x, detectionPosition.y, this.robotProxy.getX(), this.robotProxy.getY());
            if (difference <= 20.0) {
                ++this.shots;
            }
        }
    }

    @Override
    public void oppNextWaveToHit(Wave wave) {
    }

    @Override
    public void oppBulletHit(Wave wave, HitByBulletEvent hitByBulletEvent) {
        if (!this.offensive) {
            double detectionAngle = this.getDetectionAngle(wave);
            double travelDistance = RCMath.getDistanceBetweenPoints(wave.getOriginX(), wave.getOriginY(), this.robotProxy.getX(), this.robotProxy.getY());
            Point2D.Double detectionPosition = RCMath.getLocation(wave.getOriginX(), wave.getOriginY(), travelDistance, detectionAngle);
            double difference = RCMath.getDistanceBetweenPoints(detectionPosition.x, detectionPosition.y, this.robotProxy.getX(), this.robotProxy.getY());
            if (difference <= 20.0) {
                ++this.hits;
            } else if (difference <= 20.0 + this.getSloppyAimTolerance()) {
                ++this.shots;
                ++this.hits;
            } else {
                ++this.shots;
            }
        }
    }

    @Override
    public void oppWavePassing(Wave wave) {
    }

    @Override
    public void oppWavePassed(Wave wave) {
    }

    @Override
    public void oppWaveUpdated(Wave wave) {
    }

    @Override
    public void oppWaveDestroyed(Wave wave) {
    }

    @Override
    public void myWaveCreated(XBulletWave wave) {
    }

    @Override
    public void myWaveHitBullet(XBulletWave wave, Bullet myBullet) {
    }

    @Override
    public void myWaveHit(XBulletWave wave, Snapshot opponentSnapshot) {
        if (this.offensive) {
            ++this.shots;
            double detectionAngle = this.getDetectionAngle(wave);
            double travelDistance = RCMath.getDistanceBetweenPoints(wave.getOriginX(), wave.getOriginY(), opponentSnapshot.getX(), opponentSnapshot.getY());
            Point2D.Double detectionPosition = RCMath.getLocation(wave.getOriginX(), wave.getOriginY(), travelDistance, detectionAngle);
            double difference = RCMath.getDistanceBetweenPoints(detectionPosition.x, detectionPosition.y, opponentSnapshot.getX(), opponentSnapshot.getY());
            if (difference <= 20.0) {
                ++this.hits;
            }
        }
    }

    @Override
    public void myBulletHit(XBulletWave wave, BulletHitEvent bulletHitEvent) {
    }

    @Override
    public void myWavePassing(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWavePassed(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWaveDestroyed(XBulletWave wave) {
    }
}

