/*
 * Decompiled with CFR 0.152.
 */
package brainfade.melee.utils;

import brainfade.melee.utils.Enemy;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.util.Utils;

public class MeleePatternMatcher {
    final int HISTORY_LENGTH = 10000;
    final int MAX_SEARCH_LENGTH = 128;
    ArrayList history = new ArrayList();
    StringBuffer historyString = new StringBuffer();

    public void add(Enemy target) {
        double bearing = this.absoluteBearing(target.lastPosition, target.position);
        double distancePerTick = target.lastPosition.distance(target.position) / (double)target.timeSinceLastScan;
        int i = 0;
        while ((long)i < target.timeSinceLastScan) {
            PMData temp = new PMData(bearing, distancePerTick);
            if (this.history.size() > 10000) {
                this.historyString.deleteCharAt(10000);
                this.history.remove(10000);
            }
            this.history.add(0, temp);
            this.historyString.insert(0, temp.toChar());
            ++i;
        }
    }

    public Point2D predict(Point2D here, double bulletPower, Enemy target) {
        double bulletTime = 0.0;
        double bulletSpeed = 20.0 - 3.0 * bulletPower;
        Point2D position = target.position;
        int startIndex = this.findStartIndex();
        if (startIndex == -1) {
            return position;
        }
        while (true) {
            double d;
            bulletTime += bulletSpeed;
            if (!(d < here.distance(position)) || startIndex < 0) break;
            PMData current = (PMData)this.history.get(startIndex);
            position = this.vectorToLocation(current.bearing, current.distance, position);
            --startIndex;
        }
        return position;
    }

    public int findStartIndex() {
        int startIndex = -1;
        int searchlength = 128;
        if (this.historyString.length() < searchlength) {
            return startIndex;
        }
        while ((startIndex = this.historyString.toString().indexOf(this.historyString.substring(0, searchlength -= 8), 1)) < 0) {
        }
        return startIndex;
    }

    public double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    public class PMData {
        double bearing;
        double distance;

        public PMData(double bearing, double distance) {
            this.bearing = bearing;
            this.distance = distance;
        }

        public char toChar() {
            int val = 1;
            val = (int)((double)val * Math.pow(2.0, Math.round((this.distance + 1.0) / 2.0)));
            val = (int)((long)val * (1L + Math.round(Math.toDegrees(Utils.normalAbsoluteAngle((double)this.bearing)) / 10.0)));
            return (char)val;
        }
    }
}

