/*
 * Decompiled with CFR 0.152.
 */
package areb;

import areb.EnemyWave;
import areb.Util;
import java.io.PrintStream;
import java.util.Vector;

public class ActiveEnemyWaves {
    private Vector enemyWaves = new Vector();
    private double battleFieldX;
    private double battleFieldY;
    private PrintStream out;

    public ActiveEnemyWaves(PrintStream printStream, double d, double d2) {
        this.out = printStream;
        this.battleFieldX = d;
        this.battleFieldY = d2;
    }

    public void addWave(EnemyWave enemyWave) {
        this.enemyWaves.add(enemyWave);
    }

    public void checkForPassedWaves(double d, double d2) {
        for (int i = 0; i < this.enemyWaves.size(); ++i) {
            EnemyWave enemyWave = (EnemyWave)this.enemyWaves.get(i);
            if (enemyWave.hasIntersected(d, d2)) {
                this.enemyWaves.remove(i);
                break;
            }
            if (Double.isNaN(enemyWave.getAngle(d, d2))) {
                System.out.println("Found a NaN wave!");
                this.enemyWaves.remove(i);
                break;
            }
            if (!(enemyWave.getWaveVel() < 0.0)) continue;
            System.out.println("Found a negative wave speed!");
            this.enemyWaves.remove(i);
            break;
        }
    }

    public void advanceAllWaves() {
        for (int i = 0; i < this.enemyWaves.size(); ++i) {
            ((EnemyWave)this.enemyWaves.get(i)).advanceWave();
        }
    }

    public EnemyWave getClosestWave(double d, double d2) {
        double d3 = Double.POSITIVE_INFINITY;
        EnemyWave enemyWave = null;
        for (int i = 0; i < this.enemyWaves.size(); ++i) {
            double d4;
            EnemyWave enemyWave2 = (EnemyWave)this.enemyWaves.get(i);
            double d5 = enemyWave2.getWaveDist();
            double d6 = Math.abs(d5 - (d4 = Util.distance(d, d2, enemyWave2.getFireX(), enemyWave2.getFireY())));
            if (!(d6 < d3)) continue;
            d3 = d6;
            enemyWave = (EnemyWave)this.enemyWaves.get(i);
        }
        return enemyWave;
    }

    public EnemyWave getFurthestWave(double d, double d2) {
        double d3 = Double.NEGATIVE_INFINITY;
        EnemyWave enemyWave = null;
        for (int i = 0; i < this.enemyWaves.size(); ++i) {
            double d4;
            EnemyWave enemyWave2 = (EnemyWave)this.enemyWaves.get(i);
            double d5 = enemyWave2.getWaveDist();
            double d6 = Math.abs(d5 - (d4 = Util.distance(d, d2, enemyWave2.getFireX(), enemyWave2.getFireY())));
            if (!(d6 > d3)) continue;
            d3 = d6;
            enemyWave = (EnemyWave)this.enemyWaves.get(i);
        }
        return enemyWave;
    }

    public EnemyWave getWhoHitMe(double d, double d2) {
        EnemyWave enemyWave = this.getClosestWave(d, d2);
        if (enemyWave == null) {
            return null;
        }
        return enemyWave;
    }

    public void reportWaves(double d, double d2, double d3, double d4) {
        for (int i = 0; i < this.enemyWaves.size(); ++i) {
            EnemyWave enemyWave = (EnemyWave)this.enemyWaves.get(i);
            double d5 = Util.distance(d, d2, enemyWave.getFireX(), enemyWave.getFireY());
            double d6 = enemyWave.getAngle(d, d2);
        }
    }

    public int getWaveCount() {
        return this.enemyWaves.size();
    }

    public EnemyWave get(int n) {
        return (EnemyWave)this.enemyWaves.get(n);
    }
}

