/*
 * Decompiled with CFR 0.152.
 */
package synnalagma.neural;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import synnalagma.neural.Link;
import synnalagma.neural.NNError;
import synnalagma.neural.NNet;
import synnalagma.neural.Node;
import synnalagma.neural.NrPop;

class Layer {
    int nlyr;
    int nx;
    int ny;
    Layer mbuff;
    Node[] node;
    static /* synthetic */ Class class$synnalagma$neural$Node;

    Layer(int n, int n2, int n3, Layer layer) {
        this.nlyr = n;
        this.nx = n2;
        this.ny = n3;
        this.mbuff = layer;
        this.node = n3 == 0 ? new Node[n2] : new Node[n2 * n3];
    }

    Layer(int n, int n2, String string) {
        String string2 = null;
        Class<?> clazz = null;
        this.nlyr = n;
        this.nx = n2;
        this.ny = 0;
        String string3 = this.getClass().getName();
        String string4 = string3.substring(0, string3.lastIndexOf(46) + 1);
        this.mbuff = null;
        this.node = new Node[n2];
        if (n2 < 1) {
            return;
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            string2 = string4 + string;
        }
        try {
            if (clazz == null) {
                clazz = Class.forName(string2);
            }
            if (!(class$synnalagma$neural$Node == null ? (class$synnalagma$neural$Node = Layer.class$("synnalagma.neural.Node")) : class$synnalagma$neural$Node).isAssignableFrom(clazz)) {
                NNError.err("No EBP type node");
            }
            String string5 = clazz.toString();
            Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE, Float.TYPE);
            int n3 = 0;
            while (n3 < n2) {
                this.node[n3] = (Node)constructor.newInstance(new Integer(n3), new Integer(n), new Float(0.0f));
                ++n3;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            NNError.err("No Access to Class Node :" + string);
        }
        catch (InstantiationException instantiationException) {
            NNError.err("No Instantiation Class Node :" + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NNError.err("No Class Node Defined :" + string);
        }
        catch (LinkageError linkageError) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            NNError.err("No or invalid constructor :" + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            NNError.err("No Class Node Defined :" + string);
        }
    }

    Layer(int n, int n2, int n3, String string) {
        this(n, n2 * n3, string);
        this.ny = n3;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                int n6;
                int n7 = n5 + n4 * n2;
                if (n5 + 1 < n2) {
                    n6 = n5 + 1 + n4 * n2;
                    this.node[n7].ngb[0] = this.node[n6];
                }
                if (n4 + 1 < n3) {
                    n6 = n5 + (n4 + 1) * n2;
                    this.node[n7].ngb[0] = this.node[n6];
                }
                if (n5 - 1 > 0) {
                    n6 = n5 - 1 + n4 * n2;
                    this.node[n7].ngb[0] = this.node[n6];
                }
                if (n4 - 1 > 0) {
                    n6 = n5 + (n4 - 1) * n2;
                    this.node[n7].ngb[0] = this.node[n6];
                }
                ++n5;
            }
            ++n4;
        }
    }

    void linkFromAll(int n, int n2, int n3, int n4, Layer layer, float f, float f2) {
        if (n > this.node.length - 1) {
            return;
        }
        if (n3 > layer.node.length - 1) {
            return;
        }
        if (n + n2 > this.node.length) {
            n2 = this.node.length - n;
        }
        if (n3 + n4 > layer.node.length) {
            n4 = layer.node.length - n3;
        }
        float[] fArray = new float[n4];
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n4) {
                fArray[n6] = NrPop.rnd.fab(f, f2);
                ++n6;
            }
            this.node[n5 + n].nodelink(n3, n4, layer, fArray);
            ++n5;
        }
    }

    void linkFromAll(Layer layer, float f, float f2) {
        this.linkFromAll(0, this.node.length, 0, layer.node.length, layer, f, f2);
    }

    void linkOneToOne(int n, int n2, int n3, Layer layer, float f, float f2) {
        if (n > this.node.length - 1) {
            return;
        }
        if (n3 > layer.node.length - 1) {
            return;
        }
        if (n + n2 > this.node.length) {
            n2 = this.node.length - n;
        }
        if (n3 + n2 > layer.node.length) {
            n2 = layer.node.length - n3;
        }
        if (n2 < 0) {
            return;
        }
        float[] fArray = new float[1];
        int n4 = 0;
        while (n4 < n2) {
            fArray[0] = NrPop.rnd.fab(f, f2);
            this.node[n4 + n].nodelink(n4 + n, 1, layer, fArray);
            ++n4;
        }
    }

    void linkOneToOne(Layer layer, float f, float f2) {
        this.linkOneToOne(0, this.node.length, 0, layer, f, f2);
    }

    int getnlBuff() {
        if (this.mbuff != null) {
            return this.mbuff.nlyr;
        }
        return -1;
    }

    void frwLayer() {
        int n = 0;
        while (n < this.node.length) {
            this.node[n].trf();
            ++n;
        }
        n = 0;
        while (n < this.node.length) {
            this.node[n].out();
            ++n;
        }
        if (this.mbuff != null) {
            n = 0;
            while (n < this.node.length) {
                if (n < this.mbuff.node.length) {
                    this.mbuff.node[n].inp += this.node[n].out;
                }
                ++n;
            }
        }
    }

    void ebpLayer(boolean bl, float f, float f2) {
        Node node;
        int n = 0;
        while (n < this.node.length) {
            node = this.node[n];
            node.err();
            ++n;
        }
        n = 0;
        while (n < this.node.length) {
            node = this.node[n];
            node.ebp(bl, f, f2);
            ++n;
        }
    }

    void inp(int n, float f) {
        this.node[n].inp = f;
    }

    void inp(int n, int n2, float[] fArray) {
        if (n2 + n > this.node.length) {
            n2 = this.node.length - n;
        }
        if (n2 > fArray.length) {
            n2 = fArray.length;
        }
        int n3 = 0;
        while (n3 < n2) {
            this.node[n3 + n].inp = fArray[n3];
            ++n3;
        }
    }

    float out(int n) {
        return this.node[n].out;
    }

    void out(int n, int n2, float[] fArray) {
        if (n2 + n > this.node.length) {
            n2 = this.node.length - n;
        }
        if (n2 > fArray.length) {
            n2 = fArray.length;
        }
        int n3 = 0;
        while (n3 < n2) {
            fArray[n3] = this.node[n3 + n].out;
            ++n3;
        }
    }

    float err(int n, float f) {
        this.node[n].errb = this.node[n].out - f;
        return this.node[n].errb * this.node[n].errb;
    }

    float err(int n, int n2, float[] fArray) {
        float f = 0.0f;
        if (n2 + n > this.node.length) {
            n2 = this.node.length - n;
        }
        if (n2 > fArray.length) {
            n2 = fArray.length;
        }
        int n3 = 0;
        while (n3 < n2) {
            float f2;
            Node node = this.node[n3 + n];
            node.errb = f2 = node.out - fArray[n3];
            f += f2 * f2;
            ++n3;
        }
        return f / (float)n2;
    }

    void setBias(int n, float f) {
        if (n > this.node.length - 1) {
            return;
        }
        this.node[n].lnk[0].wgt = f;
    }

    void setBias(int n, int n2, float f, float f2) {
        if (n > this.node.length - 1) {
            return;
        }
        if (n2 + n > this.node.length) {
            n2 = this.node.length - n;
        }
        int n3 = 0;
        while (n3 < n2) {
            this.node[n3 + n].lnk[0].wgt = NrPop.rnd.fab(f, f2);
            ++n3;
        }
    }

    void setAllBias(float f, float f2) {
        int n = 0;
        while (n < this.node.length) {
            this.node[n].lnk[0].wgt = NrPop.rnd.fab(f, f2);
            ++n;
        }
    }

    float getBias(int n) {
        return this.node[n].lnk[0].wgt;
    }

    Layer cloneLayer() {
        String string = "";
        if (this.nx > 0) {
            string = this.node[0].getClass().getName();
        }
        Layer layer = this.ny > 0 ? new Layer(this.nlyr, this.nx, this.ny, string) : new Layer(this.nlyr, this.nx, string);
        return layer;
    }

    void cloneLink(NNet nNet) {
        int n = 0;
        while (n < this.node.length) {
            nNet.lyr[this.nlyr].node[n].lnk = new Link[this.node[n].lnk.length];
            int n2 = 0;
            while (n2 < this.node[n].lnk.length) {
                float f = this.node[n].lnk[n2].wgt;
                int n3 = this.node[n].lnk[n2].getLfrom();
                int n4 = this.node[n].lnk[n2].getNfrom();
                Node node = n4 != -1 ? nNet.lyr[n3].node[n4] : null;
                nNet.lyr[this.nlyr].node[n].lnk[n2] = new Link(f, node);
                ++n2;
            }
            ++n;
        }
    }

    void copyWLayer(Layer layer) {
        int n = layer.node.length < this.node.length ? layer.node.length : this.node.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = layer.node[n2].lnk.length < this.node[n2].lnk.length ? layer.node[n2].lnk.length : this.node[n2].lnk.length;
            int n4 = 0;
            while (n4 < n3) {
                float f;
                layer.node[n2].lnk[n4].wgt = f = this.node[n2].lnk[n4].wgt;
                ++n4;
            }
            ++n2;
        }
    }

    void inirandLayer(float f, float f2, boolean bl) {
        int n = 0;
        while (n < this.node.length) {
            if (bl) {
                this.node[n].lnk[0].wgt = NrPop.rnd.fab(f, f2);
            }
            int n2 = 1;
            while (n2 < this.node[n].lnk.length) {
                this.node[n].lnk[n2].wgt = NrPop.rnd.fab(f, f2);
                ++n2;
            }
            ++n;
        }
    }

    void wgtmutLayer(float f, float f2, boolean bl) {
        int n = 0;
        while (n < this.node.length) {
            float f3;
            if (bl) {
                f3 = this.node[n].lnk[0].wgt;
                this.node[n].lnk[0].wgt = f3 += NrPop.rnd.fab(f, f2);
            }
            int n2 = 1;
            while (n2 < this.node[n].lnk.length) {
                f3 = this.node[n].lnk[n2].wgt;
                this.node[n].lnk[n2].wgt = f3 += NrPop.rnd.fab(f, f2);
                ++n2;
            }
            ++n;
        }
    }

    void wgtmutLayer(float f, boolean bl) {
        int n = 0;
        while (n < this.node.length) {
            float f2;
            if (bl) {
                f2 = this.node[n].lnk[0].wgt;
                this.node[n].lnk[0].wgt = f2 += NrPop.rnd.gauss(f);
            }
            int n2 = 0;
            while (n2 < this.node[n].lnk.length) {
                f2 = this.node[n].lnk[n2].wgt;
                this.node[n].lnk[n2].wgt = f2 += NrPop.rnd.gauss(f);
                ++n2;
            }
            ++n;
        }
    }

    void saveLayer(PrintStream printStream) {
        String string;
        int n = -1;
        if (this.mbuff != null) {
            n = this.mbuff.nlyr;
        }
        if (this.node.length > 0) {
            string = this.node[0].getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
        } else {
            string = "unknown";
        }
        printStream.println(this.nlyr + " " + this.nx + "," + this.ny + " " + string + " " + n);
    }

    void saveLayer(DataOutputStream dataOutputStream) throws IOException {
        int n = -1;
        if (this.mbuff != null) {
            n = this.mbuff.nlyr;
        }
        String string = this.node.length > 0 ? this.node[0].getClass().getName() : "unknown";
        dataOutputStream.writeInt(this.nlyr);
        dataOutputStream.writeInt(this.nx);
        dataOutputStream.writeInt(this.ny);
        dataOutputStream.writeUTF(string);
        dataOutputStream.writeInt(n);
    }

    void saveLink(PrintStream printStream) {
        int n = 0;
        while (n < this.node.length) {
            printStream.println(n + " " + (this.node[n].lnk.length - 1) + " " + this.node[n].lnk[0].wgt);
            int n2 = 1;
            while (n2 < this.node[n].lnk.length) {
                printStream.print(this.node[n].lnk[n2].nfrom.nlyr + "," + this.node[n].lnk[n2].nfrom.nn + ":" + this.node[n].lnk[n2].wgt + " ");
                ++n2;
            }
            if (this.node[n].lnk.length > 1) {
                printStream.println(" ");
            }
            ++n;
        }
    }

    void saveLink(DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        while (n < this.node.length) {
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(this.node[n].lnk.length - 1);
            dataOutputStream.writeFloat(this.node[n].lnk[0].wgt);
            int n2 = 1;
            while (n2 < this.node[n].lnk.length) {
                dataOutputStream.writeInt(this.node[n].lnk[n2].nfrom.nlyr);
                dataOutputStream.writeInt(this.node[n].lnk[n2].nfrom.nn);
                dataOutputStream.writeFloat(this.node[n].lnk[n2].wgt);
                ++n2;
            }
            ++n;
        }
    }

    void loadLink(DataInputStream dataInputStream, Layer[] layerArray) throws IOException {
        int n = 0;
        while (n < this.node.length) {
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            this.node[n].lnk = new Link[n3 + 1];
            this.node[n].lnk[0] = new Link(dataInputStream.readFloat(), null);
            int n4 = 1;
            while (n4 < this.node[n].lnk.length) {
                int n5 = dataInputStream.readInt();
                int n6 = dataInputStream.readInt();
                float f = dataInputStream.readFloat();
                this.node[n].lnk[n4] = new Link(f, layerArray[n5].node[n6]);
                ++n4;
            }
            ++n;
        }
    }

    void loadLink(StreamTokenizer streamTokenizer, Layer[] layerArray) {
        int n = 0;
        while (n < this.node.length) {
            try {
                streamTokenizer.nextToken();
                int n2 = (int)streamTokenizer.nval;
                streamTokenizer.nextToken();
                int n3 = (int)streamTokenizer.nval;
                this.node[n].lnk = new Link[n3 + 1];
                streamTokenizer.nextToken();
                this.node[n].lnk[0] = new Link((float)streamTokenizer.nval, null);
                int n4 = 1;
                while (n4 < this.node[n].lnk.length) {
                    streamTokenizer.nextToken();
                    int n5 = (int)streamTokenizer.nval;
                    streamTokenizer.nextToken();
                    int n6 = (int)streamTokenizer.nval;
                    streamTokenizer.nextToken();
                    float f = (float)streamTokenizer.nval;
                    this.node[n].lnk[n4] = new Link(f, layerArray[n5].node[n6]);
                    ++n4;
                }
            }
            catch (IOException iOException) {
                NNError.err("Error on net file");
                return;
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

