/*
 * Decompiled with CFR 0.152.
 */
package gun;

import execution.IDrawable;
import execution.Painter;
import execution.Sequencer;
import gun.IGun;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import math.Fath;
import math.Maths;
import math.Vect2d;
import robocode.Rules;
import robocode.util.Utils;
import sim.Bot;
import sim.Data;
import sim.Stat;

public class CircularGun
implements IGun,
IDrawable {
    Painter _debug;
    Sequencer _sequencer;

    public CircularGun(Sequencer sequencer, Painter debug) {
        debug.Register(this);
        this._sequencer = sequencer;
    }

    @Override
    public double GetDeltaBearing(Bot self, Point2D.Double nextPosition, long time, Bot enemy, double bulletPower) {
        double enemyHeadingChange = enemy.Get(Stat.HEADING_OMEGA);
        return this.GetDeltaBearingInternal(self, nextPosition, time, enemy, bulletPower, enemyHeadingChange);
    }

    protected double GetDeltaBearingInternal(Bot self, Point2D.Double nextPosition, long time, Bot enemy, double bulletPower, double enemyHeadingChange) {
        Point2D.Double enemyPos = new Point2D.Double();
        enemyPos.setLocation(enemy.Position);
        double enemyHeading = enemy.Get(Stat.HEADING);
        double enemyAbsoluteBearing = enemy.Get(Stat.ABSOLUTEBEARING);
        double enemyVelocity = enemy.Get(Stat.VELOCITY);
        double enemyAcceleration = enemy.Get(Stat.ACCELERATION);
        double halfBotWidthFudge = Data.Battle.HalfRobotWidth - 1.0E-11;
        int deltaTime = 0;
        double battleFieldHeight = Data.Battle.BattleFieldHeight;
        double battleFieldWidth = Data.Battle.BattleFieldWidth;
        double bulletSpeed = Rules.getBulletSpeed((double)bulletPower);
        Vect2d vector = enemy.Heading.copy();
        while ((double)(++deltaTime) * bulletSpeed < nextPosition.distance(enemyPos)) {
            vector.setMagnitude(enemyVelocity);
            vector.movePoint(enemyPos);
            if (enemyHeadingChange != 0.0) {
                vector = Vect2d.fromHeading(enemyHeading += enemyHeadingChange);
            }
            double previousDirection = Math.signum(enemyVelocity);
            if (enemyAcceleration > 2.0) {
                enemyAcceleration = 0.0;
            }
            if (Math.signum(enemyVelocity = Maths.Accelerate(enemyVelocity, enemyAcceleration)) == -1.0 * previousDirection && enemyAcceleration != 0.0) {
                enemyAcceleration *= -1.0;
            }
            if (!(enemyPos.getX() < halfBotWidthFudge || enemyPos.getY() < halfBotWidthFudge || enemyPos.getX() > battleFieldWidth - halfBotWidthFudge) && !(enemyPos.getY() > battleFieldHeight - halfBotWidthFudge)) continue;
            break;
        }
        enemyPos.setLocation(Math.min(Math.max(Data.Battle.HalfRobotWidth, enemyPos.getX()), battleFieldWidth - Data.Battle.HalfRobotWidth), Math.min(Math.max(Data.Battle.HalfRobotWidth, enemyPos.getY()), battleFieldHeight - Data.Battle.HalfRobotWidth));
        double theta = Utils.normalAbsoluteAngle((double)Fath.atan2(enemyPos.getX() - nextPosition.getX(), enemyPos.getY() - nextPosition.getY()));
        return Utils.normalRelativeAngle((double)(theta - enemyAbsoluteBearing));
    }

    @Override
    public Color GetBulletColor() {
        return Color.GREEN;
    }

    @Override
    public void Draw(Graphics2D e) {
    }
}

