/*
 * Decompiled with CFR 0.152.
 */
package gun;

import gun.MovePredictor;
import java.awt.geom.Point2D;
import math.Maths;
import math.Vect2d;

public class CircularPredictor
extends MovePredictor {
    private double _velocity;
    private double _acceleration;
    private double _heading;
    private double _headingDelta;

    public CircularPredictor(double velocity, double aceleration, double heading, double headingDelta) {
        this._velocity = velocity;
        this._acceleration = aceleration;
        this._heading = heading;
        this._headingDelta = headingDelta;
    }

    @Override
    public final void Step(Point2D.Double start) {
        double rawVelocity = this._velocity;
        Vect2d vector = Vect2d.fromHeading(this._heading, rawVelocity);
        vector.movePoint(start);
        this._heading += this._headingDelta;
        double previousDirection = Math.signum(this._velocity);
        if (Math.abs(this._acceleration) > 2.0) {
            this._acceleration = 0.0;
        }
        this._velocity = Maths.Accelerate(this._velocity, this._acceleration);
        if (Math.signum(this._velocity) == -1.0 * previousDirection && this._acceleration != 0.0) {
            this._acceleration *= -1.0;
        }
    }
}

