/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import math.Fath;

public class Vect2d {
    private double _dx;
    private double _dy;

    public static Vect2d fromHeading(double heading) {
        return Vect2d.fromHeading(heading, 1.0);
    }

    public static Vect2d fromHeading(double heading, double distance) {
        return new Vect2d(distance * Fath.sin(heading), distance * Fath.cos(heading));
    }

    public static Vect2d fromPosition(Point2D.Double p1, Point2D.Double p2) {
        return new Vect2d(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    public Vect2d(Point2D.Double p1, Point2D.Double p2) {
        this(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    public Vect2d(double dx, double dy) {
        this._dx = dx;
        this._dy = dy;
    }

    public Vect2d copy() {
        return new Vect2d(this._dx, this._dy);
    }

    public double length() {
        return Math.sqrt(this._dx * this._dx + this._dy * this._dy);
    }

    public static Vect2d abs(Vect2d vector) {
        return new Vect2d(Math.abs(vector._dx), Math.abs(vector._dy));
    }

    public void add(Vect2d vector) {
        this._dx += vector._dx;
        this._dy += vector._dy;
    }

    public static Vect2d add(Vect2d v1, Vect2d v2) {
        return new Vect2d(v1._dx + v2._dx, v1._dy + v2._dy);
    }

    public void subtract(Vect2d vector) {
        this._dx -= vector._dx;
        this._dy -= vector._dy;
    }

    public static Vect2d subtract(Vect2d v1, Vect2d v2) {
        return new Vect2d(v1._dx - v2._dx, v1._dy - v2._dy);
    }

    public void multiply(double scalar) {
        this._dx *= scalar;
        this._dy *= scalar;
    }

    public static Vect2d multiply(Vect2d vector, double scalar) {
        return new Vect2d(vector._dx * scalar, vector._dy * scalar);
    }

    public void unitize() {
        this.setMagnitude(1.0);
    }

    public double dot(Vect2d vector) {
        return this._dx * vector._dx + this._dy * vector._dy;
    }

    public double cross(Vect2d vector) {
        return Vect2d.cross(this, vector);
    }

    public static double cross(Vect2d v1, Vect2d v2) {
        return v1._dx * v2._dy - v1._dy * v2._dx;
    }

    public static Vect2d perpendicular(Vect2d vector) {
        return new Vect2d(vector._dy, -vector._dx);
    }

    public void setMagnitude(double length) {
        double current = this.length();
        double inverseLength = current == 0.0 ? 0.0 : length / current;
        this.multiply(inverseLength);
    }

    public void addMagnitude(double length) {
        this.setMagnitude(this.length() + length);
    }

    public void movePoint(Point2D.Double point) {
        point.setLocation(point.getX() + this._dx, point.getY() + this._dy);
    }

    public Line2D.Double projectLine(Point2D.Double origin) {
        Point2D.Double end = new Point2D.Double();
        end.setLocation(origin.getX() + this._dx, origin.getY() + this._dy);
        return new Line2D.Double(origin, end);
    }

    public void moveLine(Line2D.Double line) {
        line.setLine(line.x1 + this._dx, line.y1 + this._dy, line.x2 + this._dx, line.y2 + this._dy);
    }
}

