/*
 * Decompiled with CFR 0.152.
 */
package mb.guns;

import java.awt.geom.Point2D;
import mb.MBRobot;
import mb.core.Coordinates;
import mb.core.Corner;
import mb.guns.Gun;
import mb.utils.GFTUtils;
import mb.utils.MathUtils;
import mb.waves.GFTWave;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class GFGun
extends Gun {
    private static double lateralDirection;
    private static double lastEnemyVelocity;
    private double xMax;
    private double yMax;

    public GFGun(MBRobot me) {
        super(me);
        this.xMax = me.getBattleFieldWidth();
        this.yMax = me.getBattleFieldHeight();
    }

    @Override
    public void fire(ScannedRobotEvent e) {
        double enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyDistance = e.getDistance();
        double enemyVelocity = e.getVelocity();
        if (enemyVelocity != 0.0) {
            lateralDirection = GFTUtils.sign(enemyVelocity * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing));
        }
        GFTWave wave = new GFTWave(this.getRobot());
        wave.gunLocation = new Point2D.Double(this.getX(), this.getY());
        GFTWave.targetLocation = GFTUtils.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance);
        wave.lateralDirection = lateralDirection;
        wave.bulletPower = this.getBulletPowerFromScannedDistance(e);
        wave.setSegmentations(enemyDistance, enemyVelocity, lastEnemyVelocity, this.getRobot().getGunHeading(), this.isInCorner(MathUtils.getCoordinates(this.getMyCoordinates(), this.getHeading(), e.getDistance())));
        lastEnemyVelocity = enemyVelocity;
        wave.bearing = enemyAbsoluteBearing;
        this.getRobot().setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getRobot().getGunHeadingRadians() + wave.mostVisitedBearingOffset())));
        this.setFire(wave.bulletPower);
        if (this.getRobot().getEnergy() >= wave.bulletPower) {
            this.getRobot().addCustomEvent(wave);
        }
        this.getRobot().setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getRobot().getRadarHeadingRadians())) * 2.0);
    }

    private Corner isInCorner(Coordinates enemyPos) {
        int cornerDistance = 100;
        if (enemyPos.getX() < (double)cornerDistance && enemyPos.getY() < (double)cornerDistance) {
            return Corner.LOWERLEFT;
        }
        if (enemyPos.getX() < (double)cornerDistance && enemyPos.getY() > this.yMax - (double)cornerDistance) {
            return Corner.UPPERLEFT;
        }
        if (enemyPos.getX() > this.xMax - (double)cornerDistance && enemyPos.getY() < (double)cornerDistance) {
            return Corner.LOWERRIGHT;
        }
        if (enemyPos.getX() > this.xMax - (double)cornerDistance && enemyPos.getY() > this.yMax - (double)cornerDistance) {
            return Corner.UPPERRIGHT;
        }
        return Corner.NONE;
    }
}

