/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.util.Vector;
import shrub.Heading;
import shrub.Location;
import shrub.MultiTracker;
import shrub.Sighting;

public class Navigator {
    private MultiTracker mTrackerRef = new MultiTracker();
    private Location mBattlefieldSize = new Location();
    private double mWallAvoidDistance = 100.0;
    private double mStepLength = 100.0;
    private double mStepLengthVar = 0.0;
    private int mNumPaths = 16;
    private double mPathHdngVar = 0.0;
    private int mEvalPowerLaw = 1;

    public void Initialise() {
        this.mTrackerRef = new MultiTracker();
        this.mBattlefieldSize.Initialise();
        this.mWallAvoidDistance = 100.0;
        this.mStepLength = 100.0;
        this.mStepLengthVar = 0.0;
        this.mNumPaths = 16;
        this.mPathHdngVar = 0.0;
        this.mEvalPowerLaw = 1;
    }

    public void SetTrackerRef(MultiTracker trackerRef) {
        this.mTrackerRef = trackerRef;
    }

    public void SetBattlefieldSize(Location bfCorner) {
        this.mBattlefieldSize.Set(bfCorner);
    }

    public void SetBattlefieldSize(double bfCornerX, double bfCornerY) {
        this.mBattlefieldSize.Set(bfCornerX, bfCornerY);
    }

    public void SetWallAvoidDistance(double newValue) {
        this.mWallAvoidDistance = newValue;
    }

    public void SetStepLength(double newValue) {
        this.mStepLength = newValue;
    }

    public void SetStepLengthVar(double newValue) {
        this.mStepLengthVar = newValue;
    }

    public void SetNumPaths(int newValue) {
        this.mNumPaths = newValue;
    }

    public void SetPathHdngVar(double newValue) {
        this.mPathHdngVar = newValue;
    }

    public void SetEvalPowerLaw(int newValue) {
        this.mEvalPowerLaw = newValue;
    }

    public final Location RandomWaypointAbs() {
        double maxX = this.mBattlefieldSize.GetX() - this.mWallAvoidDistance;
        double maxY = this.mBattlefieldSize.GetY() - this.mWallAvoidDistance;
        double minX = this.mWallAvoidDistance;
        double minY = this.mWallAvoidDistance;
        double deltaX = maxX - minX;
        double deltaY = maxY - minY;
        double randomX = minX + Math.random() * deltaX;
        double randomY = minY + Math.random() * deltaY;
        Location answer = new Location();
        answer.Set(randomX, randomY);
        return answer;
    }

    public final Location RandomWaypointRel(Location sourceLocn) {
        double maxX = this.mBattlefieldSize.GetX() - this.mWallAvoidDistance;
        double maxY = this.mBattlefieldSize.GetY() - this.mWallAvoidDistance;
        double minX = this.mWallAvoidDistance;
        double minY = this.mWallAvoidDistance;
        double sourceX = sourceLocn.GetX();
        double sourceY = sourceLocn.GetY();
        double randomX = Math.random() * this.mStepLength * 2.0 - this.mStepLength + sourceX;
        double randomY = Math.random() * this.mStepLength * 2.0 - this.mStepLength + sourceX;
        if (randomX > maxX) {
            randomX = maxX;
        } else if (randomX < minX) {
            randomX = minX;
        }
        if (randomY > maxY) {
            randomY = maxY;
        } else if (randomY < minY) {
            randomY = minY;
        }
        Location answer = new Location();
        answer.Set(randomX, randomY);
        return answer;
    }

    public Location QuantumGravWaypoint(Location sourceLocn) {
        Location answer = new Location();
        Heading pathHdng = new Heading();
        int pathIndex = 0;
        Vector<Location> locnArray = new Vector<Location>();
        int numPaths = this.mNumPaths;
        double pathLength = this.mStepLength;
        double pathLengthVar = this.mStepLengthVar;
        double pathHdngVar = this.mPathHdngVar;
        if (numPaths <= 0 || pathLength < 1.0) {
            System.out.println("ERROR: Navigator::QuantumGravWaypoint, input error " + numPaths + "/" + pathLength);
        } else {
            pathIndex = 0;
            pathHdng.Set(0.0);
            while (pathIndex < numPaths) {
                double adjPathLength = pathLength;
                Heading adjPathHdng = new Heading();
                adjPathHdng.Set(pathHdng);
                if (pathLengthVar > 0.5) {
                    adjPathLength = pathLength - pathLengthVar + 2.0 * Math.random() * pathLengthVar;
                }
                if (pathHdngVar > 0.5) {
                    double offset = 0.0;
                    offset = 2.0 * Math.random() * pathHdngVar - pathHdngVar;
                    adjPathHdng.Adjust(offset);
                }
                Location pathEnd = new Location();
                pathEnd.SetRelative(sourceLocn, adjPathHdng, adjPathLength);
                if (!(pathEnd.GetX() <= this.mWallAvoidDistance || pathEnd.GetY() <= this.mWallAvoidDistance || pathEnd.GetX() >= this.mBattlefieldSize.GetX() - this.mWallAvoidDistance || pathEnd.GetY() >= this.mBattlefieldSize.GetY() - this.mWallAvoidDistance)) {
                    locnArray.add(pathEnd);
                }
                pathHdng.Adjust(360.0 / (double)numPaths);
                ++pathIndex;
            }
            boolean success = this.EvaluateLocns(locnArray, answer);
            if (!success) {
                int numValidPaths = locnArray.size();
                if (numValidPaths <= 0) {
                    System.out.println("ERROR - valid paths array empty");
                } else {
                    int randomIndex = (int)(Math.random() * (double)numValidPaths);
                    Location randomEnd = (Location)locnArray.get(randomIndex);
                    answer.Set(randomEnd);
                }
            }
        }
        return answer;
    }

    public final boolean EvaluateLocns(Vector locnArray, Location answer) {
        boolean okSoFar = true;
        double biggestEvalSoFar = 0.0;
        int numLocns = 0;
        int numTargets = 0;
        numTargets = this.mTrackerRef.GetNumTargets();
        numLocns = locnArray.size();
        if (numTargets <= 0) {
            okSoFar = false;
        } else if (numLocns <= 0) {
            System.out.println("ERROR: Navigator::EvaluateLocns() - no locns!");
            okSoFar = false;
        } else {
            int locnIndex = 0;
            while (locnIndex < numLocns) {
                Location thisLocn = (Location)locnArray.get(locnIndex);
                double thisEval = this.EvalDistanceFunc(thisLocn, this.mEvalPowerLaw);
                if (thisEval > biggestEvalSoFar) {
                    biggestEvalSoFar = thisEval;
                    answer.Set(thisLocn);
                }
                ++locnIndex;
            }
        }
        return okSoFar;
    }

    public double EvalDistanceFunc(Location fromLocn, int powerLaw) {
        double sumEval = 0.0;
        sumEval = this.EvalDistanceFunc(fromLocn.GetX(), fromLocn.GetY(), powerLaw);
        return sumEval;
    }

    public double EvalDistanceFunc(double xPos, double yPos, int powerLaw) {
        double thisEval = 0.0;
        double sumEval = 0.0;
        int thisIndex = 0;
        int numTargets = 0;
        Location refLocn = new Location();
        refLocn.Set(xPos, yPos);
        sumEval = 0.0;
        thisIndex = 0;
        numTargets = this.mTrackerRef.GetNumTargets();
        while (thisIndex < numTargets) {
            Sighting thisTarget = this.mTrackerRef.GetTargetByIndex(thisIndex);
            Location thisLocn = thisTarget.GetLocation();
            double thisDist = thisLocn.DistanceTo(refLocn);
            if (powerLaw == 1) {
                thisEval = thisDist;
            } else if (powerLaw == 2) {
                thisEval = Math.sqrt(thisDist);
            } else {
                System.out.println("ERROR: Navigator, invalid power law");
            }
            sumEval += thisEval;
            ++thisIndex;
        }
        return sumEval;
    }
}

