package cx.util.iiley;

import java.awt.geom.Point2D;
import robocode.*;
/**
 *-----------------------------------------------------------------
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 * Infinity Virtule Bullets looks like a wave
 */

public class StatistWave
{
	//-------comparable varialbles---------
	public double targetDirection;
	public double distance;
	public double moveDir;
	public double moveTime;
	//----------------------------------
	private double x;
	private double y;
	public long   startTime;
	public double absBearing;
	public double velocity;   //in test it is velocity but final it is the distance
	public double power;
	//if willHitDiffAngle==10 means it is testing,==20 means it is useless,others means a succeded wave 
	public double willHitDiffAngle;
	public StatistWave(double x,double y,double power,long time,double absBearing,double targetDirection,
		double distance,double moveDir,double moveTime){
		velocity=20-power*3;
		if(power==0){
			velocity=11;
		}
		this.x=x;
		this.y=y;
		this.power=power;
		this.absBearing=absBearing;
		this.targetDirection=targetDirection;
        this.distance=distance;
		this.moveDir=moveDir;
		this.moveTime=moveTime;
        startTime=time;

		willHitDiffAngle=10D;//a very max angle show it is not a succeded value
	}
	/**
	 * test the wave (when the wave hit enemy,test succede)
	 */
	public void test(double ex,double ey,long time){
		if(willHitDiffAngle==10D){//it is not a succeded wave,so test
		    double dist=Point2D.distance(ex,ey,x,y);
			double travel=velocity*(time-startTime);
			if (travel<0 || travel-dist>18d){
				willHitDiffAngle=20D;
			}else if(Math.abs(dist-travel)<18){  //is the wav hit enemy?
				willHitDiffAngle=robocode.util.Utils.normalRelativeAngle(Math.atan2(ex-x,ey-y)-absBearing);
                velocity=dist; //recored distance in velocity
			}
		}
	}
	public static double getAngle(Point2D.Double p2,Point2D.Double p1){
		return Math.atan2(p2.x-p1.x,p2.y-p1.y);
	}
};
