package bvh.mini;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.Point2D;
import java.awt.geom.Line2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.Color;
import java.util.*;
import java.util.zip.*;
import java.io.*;

/**
 * Mjolnir - a robot by Bart van Hest
 *
 *   "When Brokk presented the hammer to Thor he listed its powers. It would 
 *    never break, it would never be lost because it would return to Thor's 
 *    hand after being thrown and it could be made smaller so Thor could keep 
 *    it in his shirt..."
 *
 *
 * Wijzigingshistorie v0.01 (04-05-2004) codesize = 1105
 *  - gebaseerd op Wodan v0.282: parameters vershittered, met verrassende resultaten.
 *
*/

public class Mjolnir extends AdvancedRobot implements Constanten {

/**********************************************************************
** Definitie van variabelen
**********************************************************************/
   // beweging
   private int                cirkelDir;
   private double             xMax, yMax, loopAfstand;
   private int                GF1Hits, tijdSindsOmkerenBeweging;
   private static boolean     vervlakBewegingsProfiel = false, rammodus = false;
   private Ellipse2D.Double   maximumCirkel;
   private Rectangle2D.Double veld;
// arme lui's APM: segmentatie o.b.v. 1:afstand
//                                    2:cirkelrichting
   private static int[][]     bewegingsStatistiek; 
   private static int         afgevuurd;
   // tegenstander
   private static String      doelNaam;
   private static int         doelTreffers = 0;
   private double             doelRichting
                             ,doelBewegingsrichting
                             ,doelEnergie
                             ,doelAfstand
                             ,doelSnelheid;
   private static Point2D.Double     doelPositie;
// GF-kanon: segmentatie o.b.v. 1:afstand
//                            , 2:doelPositie op slagveld: in middelpunt, neutraal of in hoeken.
//                            , 3:versnelling
//                            , 4:doelSnelheid
   static int[][][][][]       guessFactors;
/**********************************************************************
** Definitie van constructors
**********************************************************************/
    public Mjolnir() {
       bewegingsStatistiek = new int[5][3];
       
       cirkelDir = (Math.random() < 0.5) ? 1: -1;
       loopAfstand = 400D;
    }
/**********************************************************************
** Definitie van methods
**********************************************************************/
/**
* run: Wodan's hoofdroutine:
*/
    public void run() {
       setColors(Color.red, Color.black, Color.red);

       setAdjustGunForRobotTurn(true);
       setAdjustRadarForGunTurn(true);
       
       // initialiseer omhullenden die bepalend zijn voor inschatten positie van
       // doel op het slagveld:
       maximumCirkel = new Ellipse2D.Double( 0
                                           , 0
                                           , xMax=getBattleFieldWidth()
                                           , yMax=getBattleFieldHeight()
                                           );

       veld = new Rectangle2D.Double( WANDAFSTAND
                                    , WANDAFSTAND
                                    , xMax - WANDAFSTAND * 2
                                    , yMax - WANDAFSTAND * 2
                                    );
                                    
       do {
          turnRadarRightRadians(Double.POSITIVE_INFINITY);
       } while (true);
    }

/**********************************************************************
** Methods voor event-afhandeling:
**********************************************************************/
/**
 * onScannedRobot: What to do when you see another robot
 * let op: van alle scanned bots tijdens een radar-sweep wordt de dichtstbijzijnde bot doorgegegeven!
 */
    public void onScannedRobot(ScannedRobotEvent evt) {
      // controleren of doel al geinitialiseerd is, zo niet dan controleren of
      // gebruik kan worden gemaakt van opgeslagen doeldata.
      if (doelNaam == null) inlezenDoelData(evt);

      // bijwerken globale data
      Point2D.Double   positie = new Point2D.Double(getX(), getY());

      doelBewegingsrichting = evt.getHeadingRadians();
      doelEnergie  = evt.getEnergy();
      doelRichting = getHeadingRadians() + evt.getBearingRadians();
      doelAfstand  = evt.getDistance();
      doelPositie  = projecteerPositie(positie, doelRichting, doelAfstand);

      // navigatie:
      if ( (doelEnergie < 100 || doelAfstand < 350D) )
         navigatie(positie, doelPositie);

      // kanonsturing:
      stuurKanon(positie, doelPositie, evt);

      // radarsturing:
      stuurRadar();
   }

   public void onHitByBullet(HitByBulletEvent evt) {
      if(doelAfstand > 150D && (tijdSindsOmkerenBeweging > doelAfstand/evt.getVelocity())) {
         vervlakBewegingsProfiel = ++GF1Hits > 1;
      }
   }

/**
* onBulletHit: What to do when your bullet hits a target.
* This method will be called when one of your bullets hits another robot.
*/
   public void onBulletHit(BulletHitEvent evt) {
      if (!rammodus) doelTreffers++;
   }

/**
* onWin: controleer of doelData moet worden opgeslagen.
*/
   public void onWin(WinEvent evt) {
      opslaanDoelData();
   }

/**
* onDeath: controleer of doelData moet worden opgeslagen.
*/
   public void onDeath(DeathEvent evt){
      opslaanDoelData();
   }

/**********************************************************************
** Methods voor navigatie, kanon- en radarsturing:
**********************************************************************/
   private void navigatie(Point2D.Double botPositie, Point2D.Double doelPositie) {
      Point2D.Double   bestemming = null;
      double           pogingen = 0;
      double           richting;

      tijdSindsOmkerenBeweging++;
// op willekeurige momenten van bewegingsrichting veranderen om een plat profiel
// te krijgen: niet te vaak omdat dan een piek ontstaat op GF=0, niet te weinig
// omdat bot dan kwetsbaar wordt voor zogenaamde Head-On targetting:
      if (vervlakBewegingsProfiel && Math.random() < 0.075) {
         int afstandIndex = (int)Math.min((doelAfstand/200D),5);
         cirkelDir = (bewegingsStatistiek[afstandIndex][0] > bewegingsStatistiek[afstandIndex][2])? 1 : -1;
         tijdSindsOmkerenBeweging = 0;
         loopAfstand = 18D * (afstandIndex ); //* Math.random()+2D
         bewegingsStatistiek[afstandIndex][cirkelDir+1]++;
         if (Math.random() < 0.002)
            vervlakBewegingsProfiel = false;
      }

// bewegingsrichting kiezen loodrecht op richting naar doel: bij afwijking van de
// voorkeursafstand naderen/wijken:
      richting = bepaalRichting(doelPositie, botPositie);
      if ( getRoundNum()> 3 && doelTreffers/(afgevuurd+0.1) < 0.16 ) {
      //ram de beter bewegende tegenstander!!! anders ontwijken en GF-kanon benutten.
         richting += cirkelDir*EENACHTSTEPI;
         rammodus = true;
      }
      else {
         loopAfstand = doelAfstand;
         rammodus = false;
      }
      
// bestemming kiezen door om doel heen te draaien. Indien de nieuwe positie niet
// binnen het slagveld valt, dan afstand/draaihoek aanpassen tot dit wel het geval is.
      do {
         bestemming = projecteerPositie(doelPositie
                                       ,richting + cirkelDir*(EENZESTIENDEPI + pogingen*0.022)
                                       ,loopAfstand * (1.05 - pogingen / 300.0)
                                       );
         pogingen++;
      } while (pogingen < 150 && !slagveld(WANDAFSTAND).contains(bestemming));

// controleer of draaihoek gelijk is aan minimale draaihoek:
      double hoek = Utils.normalRelativeAngle(bepaalRichting(botPositie, bestemming) - getHeadingRadians());
      double draaiHoek = Math.atan(Math.tan(hoek));

// draai en verplaats robot:
      setTurnRightRadians(draaiHoek);
      setAhead(botPositie.distance(bestemming) * (hoek == draaiHoek ? 1 : -1));

// eventueel snelheid minderen om sneller te kunnen draaien:
      if ( Math.abs(getTurnRemainingRadians()) > KWARTPI ) 
         setMaxVelocity( (90-Math.abs(getTurnRemaining()))/7.5D );
      else
         setMaxVelocity(MAXIMUM_SNELHEID);
   }

   private RoundRectangle2D slagveld(double wandafstand) {
      return new RoundRectangle2D.Double( wandafstand
                                        , wandafstand
                                        , xMax - wandafstand * 2D
                                        , yMax - wandafstand * 2D
                                        , RONDING
                                        , RONDING
                                        );
   }

/**********************************************************************
** Kanon sturing
**********************************************************************/
   private void stuurKanon( Point2D.Double botPositie
                          , Point2D.Double doelPositie
                          , ScannedRobotEvent evt){

      double kogelSnelheid, kanonVuurkracht;

      MicroGolf mg = new MicroGolf();

      int afstandIndex      = Math.min( (int)Math.round(Math.sqrt(doelAfstand/25D)), AFSTANDSEGMENTEN );
      // 0: doelPositie binnen slagveld (meest waarschijnlijk)
      // 1: doelPositie nabij wand
      // 2: doelPositie in een van de hoeken
      int positieIndex      = veld.contains(doelPositie) ? 0 : (maximumCirkel.contains(doelPositie) ? 1 : 2);
      int versnellingsIndex = (int)Math.round(doelSnelheid-(doelSnelheid = Math.abs(evt.getVelocity())));
      if (versnellingsIndex != 0)
         versnellingsIndex = (versnellingsIndex < 0)? 1 : 2;
      double lateraleSnelheid = evt.getVelocity()*Math.sin(doelBewegingsrichting - doelRichting);
      int snelheidsIndex    = (int)(Math.abs(lateraleSnelheid)/3D);

      kanonVuurkracht = 3.25D-afstandIndex/4D;
      kogelSnelheid   = berekenKogelSnelheid( kanonVuurkracht );

      mg.startPositie     = botPositie;
      mg.richting         = doelRichting;
      mg.kogelSnelheid    = kogelSnelheid;
      mg.cirkelRichting   = lateraleSnelheid > 0 ? .7D/GF_MIDDEN : -.7D/GF_MIDDEN;
// segmentatie o.b.v. 1:DoelAfstand
//                  , 2:DoelPositie in middelpunt, neutraal of in hoeken.
//                  , 3:DoelVersnelling
//                  , 4:DoelSnelheid
      try {
         mg.stats            = guessFactors[afstandIndex]
                                           [positieIndex]
                                           [versnellingsIndex]
                                           [snelheidsIndex];
      } catch (java.lang.ArrayIndexOutOfBoundsException e){
      }

      int schattingGF = GF_MIDDEN;
      if (doelEnergie > 0 && doelSnelheid > 0) {
         for (int gf = (2*GF_MIDDEN); gf >= 0 ; gf--) //Saves one byte compared to going up (Jam)
            if (mg.stats[gf] > mg.stats[schattingGF])
               schattingGF = gf;
      }
      setTurnGunRightRadians(Utils.normalRelativeAngle(doelRichting - getGunHeadingRadians() + mg.cirkelRichting*(schattingGF-GF_MIDDEN) ));

      if (getEnergy() > kanonVuurkracht && setFireBullet(kanonVuurkracht) != null) {
         addCustomEvent(mg);
         afgevuurd++;
      }
   }

/**
* berekenKogelSnelheid: berekend de snelheid van de kogel op basis
*    van de kracht van de kogel.
*
* v0.1 (27-12-2002)
*/
   private double berekenKogelSnelheid(double kanonVuurkracht) {
      return(20D - 3D * kanonVuurkracht);
   }

/**********************************************************************
** Radar sturing
**********************************************************************/
   private void stuurRadar() {
      if ( getOthers() == 1 ) //&& doel.locked )
         setTurnRadarRightRadians(2.0D*Utils.normalRelativeAngle( doelRichting - getRadarHeadingRadians() ));
      else
         setTurnRadarRightRadians( Double.POSITIVE_INFINITY );
   }

/**********************************************************************
** hulp methods
**********************************************************************/
   private static Point2D.Double projecteerPositie(Point2D.Double pos, double richting, double afstand){
      return new Point2D.Double( pos.x + afstand * Math.sin(richting)
                               , pos.y + afstand * Math.cos(richting)
                               );
   }

   private static double bepaalRichting(Point2D.Double oorsprong, Point2D.Double doel) {
      return Math.atan2( (doel.x-oorsprong.x), (doel.y-oorsprong.y) );
   }

   private void inlezenDoelData(ScannedRobotEvent evt) {
      doelNaam = evt.getName();
      if (guessFactors==null) {

         try {
            ObjectInputStream in = new ObjectInputStream(
                                      new GZIPInputStream(
                                         new FileInputStream(getDataFile(getFilenaam(doelNaam)))));
            guessFactors = (int[][][][][])in.readObject();
            in.close();
         }
         catch (Exception ex) {
            guessFactors = new int[AFSTANDSEGMENTEN][POSITIESEGMENTEN][VERSNELLINGSSEGMENTEN][SNELHEIDSSEGMENTEN][2*GF_MIDDEN+1];
         }
      }
   }

   private void opslaanDoelData() {
      if (getRoundNum() == getNumRounds()-1) {
         try  {
            ObjectOutputStream out = new ObjectOutputStream(
                                        new GZIPOutputStream(
                                           new RobocodeFileOutputStream(getDataFile(getFilenaam(doelNaam)))));
            out.writeObject(guessFactors);
            out.close();
         }
         catch (IOException ex) {
         }
      }
   }

/**
* bepaal naam van bot gestript van het versienummer:
*/
   public static String getNaamZonderVersie(String s) {
      int  i = s.indexOf(" ");
      if (i == -1)  return( s ); // substring not found
      else          return( s.substring(0, i) );
   }

/**
* creeer een filenaam voor de datafile:
*/
   public static String getFilenaam(String s) {
      return( getNaamZonderVersie( s )+".dat" );
   }

/**********************************************************************
** innerclass met de golf.
**********************************************************************/
class MicroGolf extends Condition {

   Point2D.Double   startPositie;
   double           richting, afstand, cirkelRichting, kogelSnelheid;
   int[]            stats;

   public boolean test(){

      if ((afstand+=kogelSnelheid) >= (Mjolnir.doelPositie).distance(startPositie)){
         try {
            stats[(int)Math.round(Utils.normalRelativeAngle(bepaalRichting(startPositie, Mjolnir.doelPositie) - richting)/cirkelRichting) + GF_MIDDEN]++;
         } catch (ArrayIndexOutOfBoundsException e) {
            //System.out.println( "ArrayIndexOutOfBoundsException " + (int)Math.round(Utils.normalRelativeAngle(bepaalRichting(startPositie, Wodan.doelPositie) - richting)/cirkelRichting) + GF_MIDDEN);
         }
         removeCustomEvent(this);
      }
      return false;
   }
}
/**********************************************************************
** einde innerclass met de golf.
**********************************************************************/

}
/**********************************************************************
** EINDE CLASS miniMjolnir
**********************************************************************/