/*
 * Copyright (c) 2004 Marcin Fuszara
 */  
package fushi.PvP1;
import robocode.*;

/* Abstract targeting class used as gun targeting logic 
 * for robot
 */
public abstract class Targeting
{
   /* this method is called every main loop tick to prepare orders
    * for robot elements, before performing their actions
    */
   public abstract void run();
   
   /*
    * event handlers
    * 
    * these are called on appropriate events that come to robot
    * and are redirected here for the targeting strategy to decide what to do next;
    * default implementations do nothing
    */
   public void onBulletHit( BulletHitEvent e )
   {}
   
   public void onBulletHitBullet( BulletHitBulletEvent e )
   {}
   
   public void onBulletMissed( BulletMissedEvent e )
   {}
}