package chase.pm;

import static java.lang.Math.*;
import static robocode.util.Utils.*;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

import robocode.*;

public class Pytko extends AdvancedRobot {
	//the deepest backward trace to determine the best match
	private static final int MAX_MATCH_LENGTH = 100;
	//Limit the size of the pattern, so that it doesn't get to slow
	private static final int MAX_PATTERN_LENGTH = 10000;
	//the maximum angle difference between heading delta's to be considered a match
	private static final double MAX_ANGLE_DIFF = PI/128; //== 1.40625 degrees
	//the maximum velocity difference between velocity delta's to be considered a match
	private static final double MAX_VELOCITY_DIFF = .125;
	private static int patternLength = 0;
	private static final Rectangle2D.Double battlefield
		= new Rectangle2D.Double(17,17, 766, 566); 
	private static State head, tail;
	private static double lastHeading, lastVelocity, eDistance;
	private Point2D.Double nextPredicted;
	private ArrayList<Point2D.Double> bestList;
	
	///Raiko
	private static final double BEST_DISTANCE = 525;
	private static boolean flat = true;
	private static double lastReverseTime, circleDir = 1, enemyFirePower, numBadHits;
	
	public void run() {
		//adjust for all the turns, by way of hierarchy
		//this adjusts the radar for robot turn aswell
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		//some nice flamy red colors
		setColors(Color.red, Color.red, Color.red);
		
		//Add a break to the pattern, so that we don't
		//track patterns that never happened
		addBreak();
		lastVelocity = 100;
		
		//spin the radar
		do {
			turnRadarRightRadians(Double.POSITIVE_INFINITY);
		} while(true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		//This is the direct angle to the enemy
		double eAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
		if(getEnergy() < 0.05) return;
		
		//since this is one on one robot, reset the radar
		//we do this first as the lag may cause the robot
		//to skip a turn, this way we don't have broken scans
		
		//this is an advanced no-slip one on one radar
		double radar = normalRelativeAngle(eAbsoluteBearing - getRadarHeadingRadians());
		double arcToScan = atan(36.0 / e.getDistance());
		radar += (radar < 0) ? -arcToScan : arcToScan;
		setTurnRadarRightRadians(radar);
		
		//Initialize some more variable
		Point2D.Double myLocation = new Point2D.Double(getX(), getY());
		Point2D.Double eLocation = project(myLocation,
				eAbsoluteBearing,eDistance = e.getDistance());
		
		if(lastVelocity == 100) {
			lastHeading = e.getHeadingRadians();
			lastVelocity = e.getVelocity();
			return;
		}
		
		double eHeading, eVelocity;
		
		//record the latest data into the pattern
		addState(eHeading = e.getHeadingRadians(), eVelocity = e.getVelocity());
		
		//check and eliminate extra states over the limit
		while(patternLength > MAX_PATTERN_LENGTH) pruneTail();
		
		//update the last heading and velocity
		lastHeading = eHeading;
		lastVelocity = eVelocity;
		
		//check to see if we need to fire this tick
		if (getGunHeat()/getGunCoolingRate() < 5 && patternLength > 3) {
			//determine the bullet power and speed
			double bulletPower = 1.9;
			if(eDistance < 150) bulletPower = 3;
			if(eDistance > 600) bulletPower = 1.5;
			double bulletSpeed = 20-3*bulletPower;
			
			//now for the meat of the gun, we scan from the head
			State state = head.reverse.reverse; //atleast 2 back
			TreeSet<State> listing = new TreeSet<State>();
			while(state.reverse != null) {
				if(!state.isBreak && matchState(state, head)) {
					State state2 = state.reverse;
					State recent = head.reverse;
					int depth = 1; //could be 0 aswell
					//check to see if the state is a match for the current state
					while(matchState(state2,recent) && depth <= MAX_MATCH_LENGTH
							&& !state2.isBreak && !recent.isBreak) {
						depth++;
						state2 = state2.reverse;
						recent = recent.reverse;
					}
					state.depth = depth;
					listing.add(state);
				}
				state = state.reverse;
			}
			
			nextPredicted = null;
			Iterator<State> it = listing.iterator();
			while(it.hasNext()) {
				state = it.next().forward;
				Point2D.Double predict = eLocation;
				int predictTime = -1;
				double heading = eHeading;
				double velocity = eVelocity;
				ArrayList<Point2D.Double> list = new ArrayList<Point2D.Double>();
				while(battlefield.contains(predict)
					&& predictTime++ < predict.distance(myLocation)/bulletSpeed
					&& state != null && !state.isBreak) {
					heading = normalRelativeAngle(heading + state.headingDelta);
					velocity = max(-8, min(8,velocity + state.velocityDelta));
					predict = project(predict,heading,velocity);
					list.add(predict);
					state = state.forward;
				}
				if(battlefield.contains(predict)
				&& predictTime > predict.distance(myLocation)/bulletSpeed) {
					bestList = list;
					nextPredicted = predict;
					listing.clear();
					break;
				}
			}
			
//			if(!listing.isEmpty())
//				System.out.println("Front: " + listing.first().depth
//					+ " Last: " + listing.last().depth + " Matches: " + listing.size());
			
			if(getGunTurnRemaining() < .5 &&
				nextPredicted != null) setFire(bulletPower);
			
			double aimAngle = eAbsoluteBearing;
			if(nextPredicted != null)
				aimAngle = absoluteAngle(myLocation, nextPredicted);
			double angle = normalRelativeAngle(aimAngle-getGunHeadingRadians());
			setTurnGunRightRadians(angle);
		}
		
		
		//////////////////// Raiko
		/*-------- setup data -----*/
		double theta;
		
		/* ---- Movement ---- */
		Point2D.Double newDestination;
		
		double distDelta = 0.02 + Math.PI/2 + (eDistance > BEST_DISTANCE  ? -.1 : .5);
		while (!battlefield.contains(newDestination =
			project(myLocation, eAbsoluteBearing + circleDir*(distDelta-=0.02), 170)));
		theta = 0.5952*(20D - 3D*enemyFirePower)/eDistance;
		if ( (flat && Math.random() > Math.pow(theta, theta))
				|| distDelta < Math.PI/5 ||
				(distDelta < Math.PI/3.5 && eDistance < 400) ){
			circleDir = -circleDir;
			lastReverseTime = getTime();
		}
		
		theta = absoluteAngle(myLocation, newDestination) - getHeadingRadians();
		setAhead(Math.cos(theta)*100);
		setTurnRightRadians(Math.tan(theta));
	}
	
    public void onHitByBullet(HitByBulletEvent e) {
		if ((double)(getTime() - lastReverseTime) >
			eDistance/e.getVelocity() && eDistance > 200 && !flat) 
	    	flat = (++numBadHits/(getRoundNum()+1) > 1.1);
    }
	
	public void onPaint(Graphics2D g) {
		g.setColor(Color.white);
		g.drawString("Pattern Length: " + patternLength, 0, 20);
		if(bestList != null) {
			Point2D.Double last = null;
			for(int i=0;i<bestList.size();i++) {
				Point2D.Double c = bestList.get(i);
				if(last == null) {
					g.setColor(Color.red);
					g.fillOval((int)c.x-4, (int)c.y-4, 8, 8);
					g.setColor(Color.white);
				} else {
					g.drawLine((int)last.x, (int)last.y, (int)c.x, (int)c.y);
				}
				if(i==bestList.size()-1) {
					g.setColor(Color.GREEN);
					g.fillOval((int)c.x-4, (int)c.y-4, 8, 8);
				}
				last = c;
			}
		}
	}
	
//	public void onSkippedTurn(SkippedTurnEvent event) {
//		out.println(event.getTime() + ": Turn Skipped.");
//	}
	
	public static final boolean matchState(State s1, State s2) {
		if(s1 != null && s2 != null &&
			abs(s1.headingDelta - s2.headingDelta) <= MAX_ANGLE_DIFF
		&& abs(s1.velocityDelta - s2.velocityDelta) <= MAX_VELOCITY_DIFF) {
			return true;
		}
		return false;
	}
	
	public static void pruneTail() {
		State temp = tail;
		tail = tail.forward;
		tail.reverse = null;
		temp.forward = null;
		patternLength--;
	}
	
	public static void addState(double heading, double velocity) {
		patternLength++;
		State s = new State();
		s.headingDelta = normalRelativeAngle(heading - lastHeading);
		s.velocityDelta = velocity - lastVelocity;

		_addState(s);
	}
	
	public static void addBreak() {
		patternLength++;
		State s = new State();
		s.isBreak = true;
		
		if(head == null) {
			head = s;
		} else {
			_addState(s);
		}
	}
	
	private static void _addState(State s) {
		State tmp = head;
		head = s;
		head.reverse = tmp;
		tmp.forward = head;
		if(tail == null) {
			tail = tmp;
		}
	}
	
	public static final Point2D.Double project(Point2D.Double l, double a, double d){
		return new Point2D.Double(l.x + d*Math.sin(a), l.y + d*Math.cos(a));
	}
	public static final double absoluteAngle(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}
	
	//only in the same file for completeness
	static class State implements Comparable<State>{
		double headingDelta, velocityDelta;
		boolean isBreak;
		State reverse, forward;
		int depth;
		
		public State() {
			isBreak = false;
		}

		public int compareTo(State o) {
			return (o.depth - depth);
//			return (depth - o.depth);
		}
	}
}