package DTF.modules;

//import robocode.AdvancedRobot;
//import robocode.ScannedRobotEvent;

public final class Pattern {
	public int x,y;
	public int vx,vy; //ponder making these floats
	public int turns;
	public int turnsSinceFiredAt;
	public int scandist;
	public Pattern next;
	
	public boolean inBin; //to be used for pruning purposes, pruning X turns after previous pattern still in bins
	private boolean pruned;
	
	//figuring turns known ahead is an expensive operation.
	//we cache the minimum because the actual can change if new patterns are added.
	private int minTurnsKnownAhead=0;
	private Pattern lastKnownAheadPattern; //the pattern associated with minTurnsKnownAhead
	
	//todo store inBin and ageFromBin, updated when adding/removing from bin, and when age reaches a max, disconnect .next to allow garbage collection
	
	//thought of using shorts and bytes to save memory, but Java's struct member alignment would probably make it futile
	
	public Pattern(int x, int y, int heading, double velocity, int turns, int turnsSinceFiredAt, int scandist) {
		assert(velocity>=0);
		this.x=x;
		this.y=y;
		
		//convert heading, velocity to x,y velocity for faster similarity comparisons
		
		double r=Math.toRadians(heading);
		
		this.vx=(int)Math.round(Math.sin(r)*velocity);
		this.vy=(int)Math.round(Math.cos(r)*velocity);
		
		this.turns=turns;
		
		this.turnsSinceFiredAt=Math.min(turnsSinceFiredAt,50); //cap to sensible limit
		this.scandist=scandist;
		
	}
	
	public Pattern(Pattern other) {
		x=other.x;
		y=other.y;
		vx=other.vx;
		vy=other.vy;
		turns=other.turns;
	}
	
	
	public void add(Pattern other) {
		x+=other.x;
		y+=other.y;
	}
	public void add(Pattern other, double factor) {
		x+=other.x*factor;
		y+=other.y*factor;
	}
	public void average(Pattern other, double factor) {
		x = (int)Math.round(((double)x)*(1.0-factor) + ((double)other.x)*factor);
		y = (int)Math.round(((double)y)*(1.0-factor) + ((double)other.y)*factor);
	}
	public void subtract(Pattern other) {
		x-=other.x;
		y-=other.y;
	}

	//avoid doing anything costly here
	public int difference(Pattern other) {
		//"this" is usually most recent pattern, and "other" is old pattern we're comparing against
		
		int dx=other.x-this.x;
		int dy=other.y-this.y;
		
		int dvx=other.vx-this.vx;
		int dvy=other.vy-this.vy;

		int dt=other.turnsSinceFiredAt; //pretend that this.turnsSinceFiredAt is zero, like we're going to fire, even though we haven't yet 
		int ds=other.scandist-this.scandist;
		
		//todo optimize factors
		return (dx*dx+dy*dy) + (dvx*dvx+dvy*dvy)*20 + dt*5 + ((ds>0)?ds:-ds); 
		
		//4 29
		//5 31
		//6 16
		//10 26
		
	}
	//max acceptable difference would probably be 2000 or so

	public boolean isEqual(Pattern other) {
		//used to avoid adding lots of duplicate patterns
		return this.x==other.x && this.y==other.y && this.vx==other.vx && this.vy==other.vy;
	}
	
	public int getBin() {
		//tries to divide patterns into bins with minimal splitting up of similar patterns.
		
		//group by rough position and direction 
		
		int qx=x>>7;
		int qy=y>>7;
		
		int qvx=(vx+9)>>2;
		int qvy=(vy+9)>>2;
		
		//generate hash for group
		
		int hash=qvx+qvy*5+qx*25+qy*400;
		
		//reduce to small set of bins
		
		//prime candidates: 31, 61, 127
		return hash%31;
	}
	
	
	//todo clamp prediction to arena width/height
	
	//returns future prediction relative to base pattern similar to this one
	public Pattern predict(int turnsAhead, Pattern base) {
		int turns = this.turns + turnsAhead;
		Pattern p = this;
		Pattern last = null;
		
		if(minTurnsKnownAhead>=0 && minTurnsKnownAhead<=turnsAhead) {
			//optimization to avoid repeatedly going through the list
			p=lastKnownAheadPattern;
		}
		
		do {
			//todo cache return result for faster re-predictions
			if(p.turns==turns) {
				Pattern ret=new Pattern(p);
				//rebase x,y from this onto other
				ret.add(base);
				ret.subtract(this);
				return ret;
			} else if(p.turns>turns) {
				if(last!=null && last.turns<turns) {
					Pattern ret=new Pattern(p);
					//interpolate patterns
					ret.average(last, ((double)(p.turns-turns))/((double)(p.turns-last.turns)));
					ret.add(base);
					ret.subtract(this);
					ret.turns=turns;
					return ret;
				}
				return null;
			}
			last=p;
			p=p.next;
		} while(p!=null);
		return null;
	}
	
	//returns whether or not we know that many turns ahead
	public boolean knowAhead(int turnsAhead) {
		if(turnsAhead<=minTurnsKnownAhead) return true;
		int turns=this.turns+turnsAhead;
		
		Pattern p= ( minTurnsKnownAhead>0) ? lastKnownAheadPattern : this;
		do {
			int pTurnsAhead = p.turns - this.turns;
			if(pTurnsAhead>minTurnsKnownAhead) {
				minTurnsKnownAhead = pTurnsAhead;
				lastKnownAheadPattern = p;
			}
			
			if(p.turns>=turns) {
				return true;
			}
			p=p.next;
		} while(p!=null);
		return false;
	}
	
	public void pruneAfter(int limit) {
		if(pruned) return; //assuming limit remains constant
		Pattern p=this;
		do {
			p=p.next;
			if(p==null || p.inBin) return;
		} while(p.turns<=this.turns+limit);
		p.next=null; //detach
		pruned=true;
		if(minTurnsKnownAhead>=limit) { //actually very unlikely
			lastKnownAheadPattern=null;
			minTurnsKnownAhead=0;
		}
	}
	
	//todo getHeading, getVelocity
}
