package sgp;
import robocode.*;
import java.awt.Color;
import java.io.*;

/**
 * Drunken - a robot by Simon Parker
 */
public class Drunken extends TeamRobot
{
	static private  Drunken instance = null;

	private Strategy currentStrategy = null;
	static private DrunkenStrategyManager strategyManager = null;

	public double angularVelocity = 0;
	public JiggleAnalyser jiggleAnalyser = null;


	public Drunken()
	{
		instance = this;
		Environment.setRobot(this);
		jiggleAnalyser = new JiggleAnalyser(this);

		if (strategyManager == null)
		{
			strategyManager = new DrunkenStrategyManager();
		}

		strategyManager.reset();

	}

	static Drunken getInstance()
	{
		return instance;
	}

	/**
	 * run: Drunken's default behavior
	 */
	public void run()
	{
		reset();

		while (true)
		{
			currentStrategy = strategyManager.getStrategy();
			currentStrategy.startTurn(); //any init that needs doing at the start of the turn
			currentStrategy.setMovement(); //sets the turning angle and the ahead/back movement
			currentStrategy.setScan(); //control the radar motion
			currentStrategy.setGunRotation(); //control the gun motion and fires if neccessary
			currentStrategy.endTurn();
			execute(); // finish the turn
		}
	}

	private void reset()
	{
		if (getEnergy() > 180.0)
		{
			strategyManager.setStrategyId(strategyManager.TEAM_LEADER_STRATEGY_ID);
		}
		else
		{
			strategyManager.setStrategyId(strategyManager.DRUNKEN_SOLDIER_STRATEGY_ID);
		}

		setAdjustGunForRobotTurn(true);
		setColors(Color.white, Color.red ,Color.red);

	}

	public void onSkippedTurn(SkippedTurnEvent event)
	{
		out.println("skipping turn");
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e)
	{
		currentStrategy.onHitByBullet(e);
	}

	public void onScannedRobot(ScannedRobotEvent e)
	{
		currentStrategy.onScannedRobot(e);
	}

	public void onDeath(DeathEvent event)
	{
		//strategy handles death
		currentStrategy.onDeath(event);

		out.println(getOthers() + " robots remaining");
	}

	public void onHitWall(HitWallEvent e)
	{
		currentStrategy.onHitWall(e);
	}

	public void onHitRobot(HitRobotEvent e)
	{
		currentStrategy.onHitRobot(e);
	}

	public void onRobotDeath(RobotDeathEvent e)
	{
		currentStrategy.onRobotDeath(e);
	}

	public void onBulletHit(BulletHitEvent event)
	{
		currentStrategy.onBulletHit(event);
	}

	public void onBulletMissed(BulletMissedEvent event)
	{
		currentStrategy.onBulletMissed(event);
	}


	public void onWin(WinEvent event)
	{
		currentStrategy.onWin(event);
	}

	public void onMessageReceived(MessageEvent e)
	{
		currentStrategy.onMessageReceived(e);
	}

}
