package ags.polylunar.core;

import java.awt.Graphics2D;
import java.awt.Color;
import java.util.List;
import robocode.Event;
import ags.polylunar.base.*;
import ags.polylunar.communication.*;
import ags.polylunar.movement.*;
import ags.polylunar.weapons.*;
import ags.polylunar.robotdata.*;
import ags.polylunar.radar.*;

public abstract class Moon extends BotBase {
    private Rules rules;
    private AllyData allies;
    private EnemyData enemies;
    private TeamRadar radar;
    private TeamMovement movement;
    private GunTargeter gun;
    
    @Override
    public void _onPaint(Graphics2D g) {
    }

    @Override
    public void init() {
        rules = getRules();
        allies = new AllyData();
        enemies = new EnemyData(rules, allies);
        radar = new TeamRadar(rules, allies, enemies);
        movement = new TeamMovement(rules, allies, enemies);
        gun = new GunTargeter(rules, allies, enemies);
        this.setColors(Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE);
    }

    @Override
    public void runTick(List<Event> events) {
        updateStatus(events);
        updateScans(events);
        radar.run(getRadarActor());
        movement.run(getMovementActor());
        gun.run(getGunActor());
    }
    
    @Override
    public void broadcastMessage(java.io.Serializable s) {
        try {
            super.broadcastMessage(s);
        } catch (java.io.IOException e) {
            System.out.println("Error during sending team message!");
            e.printStackTrace();
        }
    }

    private void updateStatus(List<Event> events) {
        // Check becons
        allies.updateTick(events);
        
        // Broadcast team becon
        broadcastMessage(new BeconData(allies.status));
    }
    
    private void updateScans(List<Event> events) {
        // Update enemy tracking and broadcast
        enemies.updateTick(events, getBroadcastActor());
    }
}
