package sgp;
import robocode.*;
import java.util.*;
import java.awt.Color;
import java.io.*;

/**
 * JollyNinja - a robot by Simon Parker for melee
 */
public class JollyNinja extends AdvancedRobot
{
	private final int roundsPerIteration = 5;
	public Strategy currentStrategy = null;
	static StrategyManager strategyManager = null;

	public static JollyNinjaParameters parameters;

	private static Scorer scorer = new Scorer();

	public double angularVelocity = 0;
	public JiggleAnalyser jiggleAnalyser = null;
	public PatternAnalyser patternAnalyser = null;
	public AntiDodgeAnalyser antiDodgeAnalyser = null;
	public AverageLinearAnalyser averageLinearAnalyser = new AverageLinearAnalyser(50);

	private static JollyNinja instance = null;

	public JollyNinja()
	{
		instance = this;
		Environment.setRobot(this);
		strategyManager = StrategyManager.getInstance();
		if (jiggleAnalyser == null)
		{
			jiggleAnalyser = new JiggleAnalyser();
		}

		if (patternAnalyser == null)
		{
			patternAnalyser = new PatternAnalyser();
		}
		
		if (antiDodgeAnalyser == null)
		{
			antiDodgeAnalyser = new AntiDodgeAnalyser();
		}
	}

	static public JollyNinja getInstance()
	{
		return instance;
	}

	private void reset()
	{
		if ((getRoundNum() % roundsPerIteration) == 0)
		{
			//some construction needs to be done here
			parameters = new JollyNinjaParameters();

			parameters.reset();
			scorer.reset(getOthers());
			Impact.resetParameters
			(
				parameters.robotRadius.getValue(),
				parameters.impactTimeBoundary.getValue(),
				parameters.impactTimeWeight.getValue()
			);
		}

		strategyManager.reset();
		jiggleAnalyser.reset();
		patternAnalyser.reset();

		setAdjustGunForRobotTurn(true);
		setColors(Color.red,Color.black,Color.black);


	}


	/**
	 * run: JollyNinja's default behavior
	 */
	public void run()
	{
		reset();

		while (true)
		{
			Environment.notifyStartTurn();
			currentStrategy.startTurn(); //any init that needs doing at the start of the turn
			currentStrategy.setMovement(); //sets the turning angle and the ahead/back movement
			currentStrategy.setScan(); //control the radar motion
			currentStrategy.setGunRotation(); //control the gun motion and fires if neccessary
			
			Environment.notifyEndTurn();
			currentStrategy.endTurn();
			execute(); // finish the turn
		}
	}

	public void onSkippedTurn(SkippedTurnEvent event)
	{
		out.print(".");
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e)
	{
		scorer.onHitByBullet(e);
		currentStrategy.onHitByBullet(e);
	}

	public void onScannedRobot(ScannedRobotEvent e)
	{
		Environment.notifyStartTurn();
	
		currentStrategy.onScannedRobot(e);
		
		Environment.notifyEndTurn();		
	}

	public void onDeath(DeathEvent event)
	{
		scorer.onDeath(getOthers());

		//strategy handles death
		currentStrategy.onDeath(event);

		if ((getRoundNum() % roundsPerIteration) == (roundsPerIteration-1))
		{
			parameters.setResult(scorer.score); //???
		}
		out.println(getOthers() + " robots remaining");
	}

	public void onHitWall(HitWallEvent e)
	{
		currentStrategy.onHitWall(e);
	}

	public void onHitRobot(HitRobotEvent e)
	{
		currentStrategy.onHitRobot(e);
	}

	public void onRobotDeath(RobotDeathEvent e)
	{
		scorer.onRobotDeath(e);
		currentStrategy.onRobotDeath(e);
	}
	
	public void onBulletHit(BulletHitEvent event)
	{
		scorer.onBulletHit(event);
		currentStrategy.onBulletHit(event);
	}

	public void onBulletMissed(BulletMissedEvent event)
	{
		currentStrategy.onBulletMissed(event);
	}


	public void onWin(WinEvent event)
	{
		scorer.onWin(event);

		currentStrategy.onWin(event);

		if ((getRoundNum() % roundsPerIteration) == (roundsPerIteration-1))
		{
			parameters.setResult(scorer.score); //???
		}
	}





}
