
package sgp;

public class RandomIntercept extends LinearIntercept
{
	
	protected Coordinate getEstimatedPosition(double time)
	{
		final double MAX_VELOCITY = 8.0;
		
		double x = targetStartingPoint.x + RandomAnalyser.randomWeight * MAX_VELOCITY * time * Math.sin(Math.toRadians(targetHeading));
		double y = targetStartingPoint.y + RandomAnalyser.randomWeight * MAX_VELOCITY * time * Math.cos(Math.toRadians(targetHeading));

		return new Coordinate(x,y);
	}


}
