package kawigi.sbf;
import java.awt.geom.*;
/**
 * MiniBullet2 - like MiniBullet from FloodMini, but doesn't returns actual angle offsets instead of factored angles, only modified relative to their initial lateral direction.
 */
public class MiniBullet2
{
	private double startx, starty, startgunheading;
	private long firetime, lasttime;
	private double lastx, lasty;
	private int direction;
	int latspeed, dindex, wallrel;
	
	public MiniBullet2(double startx, double starty, int direction, int latv, int dindex, int wallrel, double ex, double ey, double absbearing, long firetime)
	{
		//for the sake of accuracy, get the distance at firing time
		this.dindex = dindex;
		latspeed = latv;
		this.wallrel = wallrel;
		//direction is 1 if the enemy was last seen going around me clockwise, -1 if they were moving counterclockwise
		this.direction = direction;
		this.startx = startx;
		this.starty = starty;
		lastx = ex;
		lasty = ey;
		startgunheading = absbearing;
		this.firetime = lasttime = firetime;
	}
	
	public double updateEnemy(double x, double y, long time)
	{
		//I just linearly interpolate where they've been if I don't get an update each tick.  Should be a
		//reasonable interpolation, at least relative to firing angle, as long as I don't often go several turns
		//without a scan.
		long dtime;
		double dx = (x-lastx)/(dtime = time-lasttime);
		double dy = (y-lasty)/dtime;
		do
		{
			if (Point2D.distance(lastx, lasty, startx, starty) <= 11*(lasttime-firetime))  	//could have hit now.
				return direction*robocode.util.Utils.normalRelativeAngle(Math.atan2(lastx-startx, lasty-starty)-startgunheading);
			lastx+=dx;
			lasty+=dy;
			lasttime++;
		}
		while (lasttime < time);
		return Double.NaN;
	}
}
