/*
 * Created on May 31, 2003
 *
 * A catch-all for those functions that don't necessarily belong
 * somewhere else
 */
package jep;

import java.awt.geom.*;

import robocode.AdvancedRobot;

public class Utils {
	
	public static double battleFieldWidth;
	public static double battleFieldHeight;
	public static double headingRadians;
	public static double gunHeadingRadians;
	public static double radarHeadingRadians;
	public static double velocity;
	public static double energy;
	public static double turnRemainingRadians;
	public static double gunTurnRemainingRadians;
	public static double radarTurnRemainingRadians;
	public static double x;
	public static double y;
	public static long currTime;
	
	public static Point2D.Double myLocation = new Point2D.Double(0, 0);
	
	public static void initVars(AdvancedRobot me) {
		battleFieldWidth = me.getBattleFieldWidth();
		battleFieldHeight = me.getBattleFieldHeight();
		updateVars(me);
	}
	
	public static void updateVars(AdvancedRobot me) {	
		headingRadians = me.getHeadingRadians();
		gunHeadingRadians = me.getGunHeadingRadians();
		radarHeadingRadians = me.getRadarHeadingRadians();
		velocity = me.getVelocity();
		energy = me.getEnergy();
		turnRemainingRadians = me.getTurnRemainingRadians();
		gunTurnRemainingRadians = me.getGunTurnRemainingRadians();
		radarTurnRemainingRadians = me.getRadarTurnRemaining();
		x = me.getX();
		y = me.getY();
		myLocation.setLocation(x, y);
		currTime = me.getTime();
	}
	
	public static double normalRelativeAngle(double angle) {
		return ((angle + 7*180) % (2*180)) - 180;
	}
	
	public static double normalRelativeAngleRadians(double angle) {
		return ((angle + 7*Math.PI) % (2*Math.PI)) - Math.PI;
	}
	
	public static Point2D.Double bearingAndDistanceToXY(double myX, double myY, double heading, double bearing, double distance) {
		Point2D.Double xy = new Point2D.Double();
		double theta = normalRelativeAngle(heading + bearing);
		xy.setLocation(myX + distance*Math.sin(Math.toRadians(theta)), myY + distance*Math.cos(Math.toRadians(theta)));
		
		return xy;
	}
	
	public static Point2D.Double calcWallIntercept(double x, double y, double heading, double maxX, double maxY) {
		if (heading == 90.0) {
			return new Point2D.Double(maxX, y);
		}
		if (heading == 270.0) {
			return new Point2D.Double(0.0, y);
		}
		Point2D.Double interceptPoint = new Point2D.Double(0.0, 0.0);
		double topIntercept = x + (maxY - y)/Math.tan(Math.toRadians(90.0 - heading));
		double rightIntercept = y + (maxX -x)*Math.tan(Math.toRadians(90.0 - heading));;
		double bottomIntercept = x - (topIntercept - x)*y/(maxY - y);
		double leftIntercept = y - (rightIntercept - y)*x/(maxX - x);
		if (topIntercept >= 0.0 && topIntercept <= maxX && (heading >= 270.0 || heading < 90.0)) {
			interceptPoint.setLocation(topIntercept, maxY);
		}
		if (bottomIntercept >= 0.0 && bottomIntercept <= maxX && heading >= 90.0 && heading < 270.0) {
			interceptPoint.setLocation(bottomIntercept, 0.0);
		}
		if (rightIntercept >= 0.0 && rightIntercept <= maxY && heading >= 0.0 && heading < 180.0) {
			interceptPoint.setLocation(maxX, rightIntercept);
		}
		if (leftIntercept >= 0.0 && leftIntercept <= maxY && heading >= 180.0 && heading < 360.0) {
			interceptPoint.setLocation(0.0, leftIntercept);
		}
		return interceptPoint;
	}
	
	public static Point2D.Double pointAdd(Point2D.Double p1, Point2D.Double p2) {
		return new Point2D.Double(p1.getX() + p2.getX(), p1.getY() + p2.getY());
	}

	public static double absoluteBearingRadians(Point2D.Double source, Point2D.Double target) {
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}
	
	public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
		return Math.toDegrees(absoluteBearingRadians(source, target));
	}
	
	public static int sign(double x) {
		if (x < 0) {
			return -1;
		} else if (x > 0) {
			return 1;
		} else {
			return 0;
		}
	}
	
	public static void out(String outString) {
		System.out.println(outString);
	}
}
