package pl.Patton;

import robocode.*;

import java.awt.Color;

import pl.Abstract.*;
import pl.Patton.Strategies.*;

/*******************************************************************************
 * General Patton - named after WWII General Smith Patton. He was a supporter of
 * tank warfare :)
 * <p />
 * GeneralPatTon is built for both melee and duel, using Strategies, and
 * delegates all control to the Strategy currently being used.
 * <p />
 * In the melee part of it, it uses strafing movement, a predictive gun, and a
 * non-stop radar. In the duel part of it, it uses wave surfing, a predictive
 * gun and a guess-factor gun, and an oscillating radar.
 * <p />
 * 
 * @author Patrick Lin
 * @version 1.54
 ******************************************************************************/
public class GeneralPatton extends StrategyUsingRobot {

	// Colors - names and RGB codes from
	// http://www.pitt.edu/~nisg/cis/web/cgi/rgb.html
	public final static Color OLIVE_DRAB = new Color(107, 142, 35);
	public final static Color KHAKI_3 = new Color(205, 198, 115);
	public final static Color SLATE_GRAY_4 = new Color(108, 123, 139);
	public final static Color GRAY_84 = new Color(214, 214, 214);
	public final static Color SLATE_BLUE = new Color(106, 90, 205);

	// My personal strategies
	public static Strategy MELEE;
	public static Strategy DUEL;

	public void run() {
		if (getRoundNum() == 0) {
			// Initialize my strategies first round only
			MELEE = new Melee(this);
			DUEL = new Duel(this);
			// Set tank-worthy colors
			setColors();
		}
		strategy = getOthers() > 1 ? MELEE : DUEL;
		strategy.run();
	}

	public void onRobotDeath(RobotDeathEvent e) {
		if (getOthers() == 1)
			strategy = DUEL;
		super.onRobotDeath(e);
	}

	public void setColors() {
		setBodyColor(OLIVE_DRAB);
		setGunColor(KHAKI_3);
		setRadarColor(SLATE_GRAY_4);
		setBulletColor(GRAY_84);
		setScanColor(SLATE_BLUE);
	}
}