package shinh;

import robocode.*;
import java.util.Vector;

public class EnemyMgr {
	public Vector enemies;

	public EnemyMgr() {
		enemies = new Vector(20);
	}

	public void handleScanned(ScannedRobotEvent e) {
		Enemy enemy = getFromName(e.getName());
		if (enemy == null) {
			enemy = new Enemy(e.getName());
			setPred(enemy);
			enemy.setScanned(e);
			enemies.add(enemy);
		}
		else {
			enemy.setScanned(e);
		}
	}

	public void handleHit(HitRobotEvent e) {
		Enemy enemy = getFromName(e.getName());
		if (enemy == null) return;
		enemy.setHit(e);
	}

	public void handleBulletHit(BulletHitEvent e) {
		Enemy enemy = getFromName(e.getName());
		if (enemy == null) return;
		enemy.setBulletHit(e);
	}

	public void setPred(Enemy e) {
		if (Entangled.name2pred.containsKey(e.name)) {
			e.revolver = (PredictRevolver2)Entangled.name2pred.get(e.name);
			e.revolver.setEnemy(e);
			e.revolver.revolve();
			e.predictor.resetEnemy(e);
		}
		else {
			PredictRevolver2 p = new PredictRevolver2(e);
			Entangled.name2pred.put(e.name, p);
			e.revolver = p;
			e.revolver.revolve();
		}
	}

	public void update() {
		for (int i = 0; i < enemies.size(); i++) {
			get(i).update();
		}
	}

	public int getIndex(String name) {
		for (int i = 0; i < enemies.size(); i++) {
			if (get(i).name == name) return i;
		}
		return -1;
	}

	public Enemy getFromName(String name) {
		return get(getIndex(name));
	}

	public Enemy get(int index) {
		return (index == -1) ? null : (Enemy)enemies.get(index);
	}

	public int size() {
		return enemies.size();
	}

	public void removeFromName(String name) {
		int i = getIndex(name);
		if (i != -1) {
			get(i).energy = 0;
			enemies.remove(getIndex(name));
		}
	}
}

