package shinh;

import robocode.*;

import java.util.Vector;
import java.awt.geom.Point2D;

public class PatternMatcher {
	private class PatternElement {
		public double velocity;
		public double angleChange;
		public long turn;
		public boolean bullet = false;
		public PatternElement(double v, double a) {
			velocity = v;
			angleChange = a;
		}
	}

	private Entangled ent;
	private Vector pattern_;
	private double lastVelocity_ = 0;
	private double lastAngle_ = 0;
	private long lastTurn_ = 0;
	private double lastRelative_ = 0;

	private boolean counterAngle_[];
	private boolean counterVelocity_[];

	private Being enemy_;

	public int start_[];
	public double point_[];

	public double x;
	public double y;
	public double point;

	public PatternMatcher(Being enemy) {
		resetEnemy(enemy);
		pattern_ = new Vector();

		start_ = new int[3];
		point_ = new double[3];
		counterAngle_ = new boolean[3];
		counterVelocity_ = new boolean[3];
	}

	public void resetEnemy(Being enemy) {
		ent = Entangled.me;

		enemy_ = enemy;
	}

	public void addState() {
		double v = enemy_.velocity;
		double a = enemy_.heading;
		long dt = enemy_.turn - lastTurn_;
		double dv = (v - lastVelocity_) / dt;
		double da = (a - lastAngle_) / dt;
		long lbt = ent.lastBulletTurn - lastTurn_;

		for (long i = 1; i <= dt; i++) {
			PatternElement pe = new PatternElement(lastVelocity_+dv*i, da);
			if (enemy_ instanceof Enemy &&
				(lbt == i || lbt == i+1 || lbt == i-1)) pe.bullet = true;
			pattern_.add(pe);
		}

		while (pattern_.size() > Const.PATTERN_HOLD_NUM) {
			pattern_.remove(0);
		}

		lastVelocity_ = v;
		lastAngle_ = a;
		lastTurn_ = enemy_.turn;
	}

	static public double NO_MATCH = 100000;

	public void calc(int next) {
		point_[0] = NO_MATCH;
		point_[1] = NO_MATCH;
		point_[2] = NO_MATCH;

		x = enemy_.x;
		y = enemy_.y;

		if (pattern_.size() < Const.PATTERN_PREDICT_TURN + next) return;

		int t = pattern_.size() - Const.PATTERN_PREDICT_TURN;
		start_[0] = 0;
		start_[1] = 0;
		start_[2] = 0;

		for (int i = 0;
			 i < pattern_.size() - Const.PATTERN_PREDICT_TURN - next; i++)
		{
			double pnt = 0;
			double pnt2 = 0;
			double pnt3 = 0;
			double pnt4 = 0;
			boolean small1 = true;
			boolean small2 = true;
			boolean small3 = true;
			boolean small4 = true;
			int j;
			for (j = 0; j < Const.PATTERN_PREDICT_TURN; j++) {
				PatternElement peOld = (PatternElement)pattern_.get(i+j);
				PatternElement peNow = (PatternElement)pattern_.get(t+j);
				if (small1) {
					double dv = peOld.velocity-peNow.velocity;
					if (dv > 0) pnt += dv;
					else pnt -= dv;
					double da = peOld.angleChange-peNow.angleChange;
					if (da > 0) pnt += da;
					else pnt -= da;
					small1 = pnt < point_[2];
				}
				if (small2) {
					double dv = peOld.velocity-peNow.velocity;
					if (dv > 0) pnt2 += dv;
					else pnt2 -= dv;
					double da = peOld.angleChange+peNow.angleChange;
					if (da > 0) pnt2 += da;
					else pnt2 -= da;
					small2 = pnt2 < point_[2];
				}
				if (small3) {
					double dv = peOld.velocity+peNow.velocity;
					if (dv > 0) pnt3 += dv;
					else pnt3 -= dv;
					double da = peOld.angleChange-peNow.angleChange;
					if (da > 0) pnt3 += da;
					else pnt3 -= da;
					small3 = pnt3 < point_[2];
				}
				if (small4) {
					double dv = peOld.velocity+peNow.velocity;
					if (dv > 0) pnt4 += dv;
					else pnt4 -= dv;
					double da = peOld.angleChange+peNow.angleChange;
					if (da > 0) pnt4 += da;
					else pnt4 -= da;
					small4 = pnt4 < point_[2];
				}
				if (!(small1 || small2 || small3 || small4)) break;
			}

			if (j != Const.PATTERN_PREDICT_TURN) continue;

			PatternElement pe =
				(PatternElement)pattern_.get(i+Const.PATTERN_PREDICT_TURN);

			if (pe.bullet) {
				pnt *= 0.9;
				pnt2 *= 0.9;
				pnt3 *= 0.9;
				pnt4 *= 0.9;
			}

			if (pnt < point_[2]) {
				start_[2] = i + Const.PATTERN_PREDICT_TURN;
				point_[2] = pnt;
				counterAngle_[2] = false;
				counterVelocity_[2] = false;
			}
			if (pnt2 < point_[2]) {
				start_[2] = i + Const.PATTERN_PREDICT_TURN;
				point_[2] = pnt2;
				counterAngle_[2] = true;
				counterVelocity_[2] = false;
			}
			if (pnt3 < point_[2]) {
				start_[2] = i + Const.PATTERN_PREDICT_TURN;
				point_[2] = pnt3;
				counterAngle_[2] = false;
				counterVelocity_[2] = true;
			}
			if (pnt4 < point_[2]) {
				start_[2] = i + Const.PATTERN_PREDICT_TURN;
				point_[2] = pnt4;
				counterAngle_[2] = true;
				counterVelocity_[2] = true;
			}
/*
			if (point_[2] < point_[1]) {
				int s = start_[1];
				double p = point_[1];
				boolean ca = counterAngle_[1];
				boolean cv = counterVelocity_[1];
				start_[1] = start_[2];
				point_[1] = point_[2];
				counterAngle_[1] = counterAngle_[2];
				counterVelocity_[1] = counterVelocity_[2];
				start_[2] = s;
				point_[2] = p;
				counterAngle_[2] = ca;
				counterVelocity_[2] = cv;
			}
			if (point_[1] < point_[0]) {
				int s = start_[0];
				double p = point_[0];
				boolean ca = counterAngle_[0];
				boolean cv = counterVelocity_[0];
				start_[0] = start_[1];
				point_[0] = point_[1];
				counterAngle_[0] = counterAngle_[1];
				counterVelocity_[0] = counterVelocity_[1];
				start_[1] = s;
				point_[1] = p;
				counterAngle_[1] = ca;
				counterVelocity_[1] = cv;
			}
*/
		}

//		point = point_[0];
		point = point_[2];
	}

	public void guessSub(int next, int index) {
		double h = enemy_.heading;

		if (next >= 0) {
			for (int i = 0; i < next; i++) {
				if (start_[index] >= pattern_.size()) {
					start_[index] = pattern_.size()-1;
					return;
				}

				PatternElement pe =
					(PatternElement)pattern_.get(start_[index]);
				start_[index]++;
				if (counterAngle_[index]) h -= pe.angleChange;
				else h += pe.angleChange;
				double v = pe.velocity;
				if (counterVelocity_[index]) v = -v;
				x += v * Math.sin(h);
				y += v * Math.cos(h);

				if (x < Const.WALL_AVOID_INTERVAL)
					x = Const.WALL_AVOID_INTERVAL;
				else if (x > ent.fieldW - Const.WALL_AVOID_INTERVAL)
					x = ent.fieldW - Const.WALL_AVOID_INTERVAL;
				if (y < Const.WALL_AVOID_INTERVAL)
					y = Const.WALL_AVOID_INTERVAL;
				else if (y > ent.fieldH - Const.WALL_AVOID_INTERVAL)
					y = ent.fieldH - Const.WALL_AVOID_INTERVAL;
			}
		}
		else {
			for (int i = 0; i > next; i--) {
				start_[index]--;
				if (start_[index] < 0) {
					start_[index] = 0;
					return;
				}
				PatternElement pe =
					(PatternElement)pattern_.get(start_[index]);

				if (counterAngle_[index]) h += pe.angleChange;
				else h -= pe.angleChange;
				double v = pe.velocity;
				if (counterVelocity_[index]) v = -v;
				x -= v * Math.sin(h);
				y -= v * Math.cos(h);

				if (x < Const.WALL_AVOID_INTERVAL)
					x = Const.WALL_AVOID_INTERVAL;
				else if (x > ent.fieldW - Const.WALL_AVOID_INTERVAL)
					x = ent.fieldW - Const.WALL_AVOID_INTERVAL;
				if (y < Const.WALL_AVOID_INTERVAL)
					y = Const.WALL_AVOID_INTERVAL;
				else if (y > ent.fieldH - Const.WALL_AVOID_INTERVAL)
					y = ent.fieldH - Const.WALL_AVOID_INTERVAL;
			}
		}
	}

	public void guess(int next) {
		guessSub(next, 2);

/*
		if (point_[2] == NO_MATCH ||
			1 / point_[0] >= (1 / point_[1] + 1 / point_[2])*0.6)
		{
			guessSub(next, 0);
		}
		else {
			guessSub(next, 2);
			double x2 = x;
			double y2 = y;
			guessSub(next, 1);
			double x1 = x;
			double y1 = y;
			guessSub(next, 0);

			double d12 = Util.distance2(x1, y1, x2, y2);
			double d01 = Util.distance2(x, y, x1, y1);
			double d20 = Util.distance2(x2, y2, x, y);

			if (d12 < d01 && d12 < d20) {
				x = (x1 + x2) * 0.5;
				y = (y1 + y2) * 0.5;
				ent.out.println(""+new Point2D.Double(x,y)+","+new Point2D.Double(x1,y1)+","+new Point2D.Double(x2,y2)+","+point_[0]+","+point_[1]+","+point_[2]);
			}
			else {}    // now x and y is ok.
		}
*/
	}

}
