package shinh;

import robocode.*;

public class PredictPattern extends Predictor {
	private Entangled ent;

	private boolean valid_ = false;

	public PatternMatcher pattern;

	public String name() {
		return "pattern";
	}

	public PredictPattern(Enemy ene) {
		ent = Entangled.me;
		pattern = new PatternMatcher(ene);
	}

	public void resetEnemy(Enemy ene) {
		pattern.resetEnemy(ene);
	}

	public boolean isValid() {
		return valid_;
	}

	public double getFutureAim(Enemy ene, double pow) {
		valid_ = false;

		double bv = 20 - pow * 3;
		int next = (int)(ene.distance / bv);
		pattern.calc(next);
		if (pattern.point == PatternMatcher.NO_MATCH) {
			return ene.radian;
		}

		int prev = 0;
		for (int i = 0; i < 5; i++) {
			pattern.guess(next-prev);
			prev = next;
			next =
				(int)(Util.distance(pattern.x, pattern.y,
									ent.getX(), ent.getY()) / bv);
			if (next == prev) break;
		}

		Being huture = new Being();
		huture.x = pattern.x;
		huture.y = pattern.y;

		huture.clip();
		huture.recalcRadian();

		if (ent.getTime() < 120 ||
			(pattern.point < 1.5 &&
			 (ent.getEnergy() > 20 ||
			  pattern.point < ent.getEnergy() * 0.05 + 0.5)) ||
			(ent.getOthers() > 1 && pattern.point < 2))
		{
			valid_ = true;
		}

		return huture.radian;
	}

}
