package erdnis;
import robocode.*;
import java.util.*;

/**
 * Rover - a robot by erdnis
 */

/* Version history:
 * 
 * 0.1 	First release. Based my previous bots. Uses circular targeting
 * 		and some kind of anti-gravity movement.
 * 
 * 0.2	Added bullets to the gravity check. Also randomized the movement a bit
 * 		to prevent it from just moving in circles.
 * 
 */
public class Rover extends AdvancedRobot
{
	
	public static final double  PI = Math.PI;
	
	double enemyAbsoluteBearing = 0;
	int timeSinceLastScan = 10;
	ArrayList enemies = new ArrayList();
	ArrayList bullets = new ArrayList();
	Enemy currentlyShootingAt = null;


	public void run() {
		
		setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);

		setTurnRadarLeftRadians(2*PI);
		
		while(true) {

			double absoluteBestAngle = calculateDirection();
			double relativeAngle = getRelativeAngle(absoluteBestAngle - getHeadingRadians());
			
			//out.println(relativeAngle);
			int dir = 1;
			if(Math.abs(relativeAngle) > PI/2){
				dir *= -1.0;
	            if (relativeAngle > 0.0) {
	            	relativeAngle -= PI;
	            }
	            else {
	            	relativeAngle += PI;
	            }
			}
			
			
			
			setTurnRightRadians(relativeAngle);
			setAhead(dir*50);
			
			doScanner();
			checkBullets();
			
			Enemy closestEnemy = null;
			double minDistance;
			if(currentlyShootingAt != null) {
				minDistance = currentlyShootingAt.distance;
				closestEnemy = currentlyShootingAt;
			} else {
				minDistance = 10000;
			}
			for(int i=0;i<enemies.size();i++) {
				if(((Enemy)enemies.get(i)).distance < (minDistance - 100)) {
					minDistance = ((Enemy)enemies.get(i)).distance;
					closestEnemy = (Enemy)enemies.get(i);
				}
			}
			if(closestEnemy != null){
				doFire(closestEnemy);
				currentlyShootingAt = closestEnemy;
			}
			execute();
			scan();
		}
	}
	
	//********************************
	//check for walls
	//********************************
//	public void wallcheck(){
//		if (getX()<50 || getX()>getBattleFieldWidth()-50 || getY()<50 || getY()>getBattleFieldHeight()-50) {
//			dir = -1;
//		} else {
//			dir = 1;
//		}
//	}

	//********************************
	//onScannedRobot
	//********************************
	public void onScannedRobot(ScannedRobotEvent e) {
		enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = Math.sin(enemyAbsoluteBearing)*e.getDistance() + getX();
		double enemyY = Math.cos(enemyAbsoluteBearing)*e.getDistance() + getY();		
		
		
		Enemy scannedEnemy = null;
		for(int i=0;i<enemies.size();i++){
			if(((Enemy)enemies.get(i)).name.equals(e.getName())){
				scannedEnemy = (Enemy)enemies.get(i);
			}
		}
		
		
		if(scannedEnemy == null){
			enemies.add(new Enemy(e.getName()));
			scannedEnemy = (Enemy)enemies.get(enemies.size() - 1);
			
			
			//scannedEnemy.turnrate=0;
			scannedEnemy.lastScanned=getTime();
			
			scannedEnemy.timesScanned = 1;
			scannedEnemy.x = enemyX;
			scannedEnemy.y = enemyY;
			scannedEnemy.distance = e.getDistance();
			scannedEnemy.velocity = e.getVelocity();
			scannedEnemy.heading = e.getHeadingRadians();
			scannedEnemy.energy = e.getEnergy();
			
			scannedEnemy.avgVelocity = e.getVelocity();
			scannedEnemy.avgTurnrate = 0;
			
			//if(getTime()-scannedEnemy.lastScanned != 0)
			//enemies.add(new Enemy(e.getName(), enemyX, enemyY, e.getDistance(), e.getVelocity(), e.getHeadingRadians(), e.getEnergy(), -1, getTime(), -1, e.getVelocity(), -1));
		} else {
			
			if((scannedEnemy.energy - e.getEnergy()) <= 3 && (scannedEnemy.energy - e.getEnergy()) >= 0.1){
				bullets.add(new EnemyBullet(getTime(), enemyX, getX(), enemyY, getY(), scannedEnemy.energy - e.getEnergy()));
			}
			
			scannedEnemy.turnrate.add(getRelativeAngle(e.getHeadingRadians() - scannedEnemy.heading)/(getTime()-scannedEnemy.lastScanned));
			scannedEnemy.lastScanned=getTime();
			
			
			scannedEnemy.timesScanned++;
			scannedEnemy.x = enemyX;
			scannedEnemy.y = enemyY;
			scannedEnemy.distance = e.getDistance();
			scannedEnemy.velocity = e.getVelocity();
			scannedEnemy.heading = e.getHeadingRadians();
			scannedEnemy.energy = e.getEnergy();
//			if(scannedEnemy.timesScanned < 10){
				scannedEnemy.avgVelocity = (scannedEnemy.avgVelocity*scannedEnemy.timesScanned + e.getVelocity())/(scannedEnemy.timesScanned + 1);
				//scannedEnemy.avgTurnrate = (scannedEnemy.avgTurnrate*scannedEnemy.timesScanned + scannedEnemy.turnrate)/(scannedEnemy.timesScanned + 1);	
//			} else {
//				scannedEnemy.avgVelocity = (scannedEnemy.avgVelocity*10 + e.getVelocity())/11;
//				scannedEnemy.avgTurnrate = (scannedEnemy.avgTurnrate*10 + scannedEnemy.turnrate)/11;
//			}
			
		}
		
		timeSinceLastScan = 0;
	}
	
	//********************************
	//When another robot dies, remove that robot
	//********************************
	public void onRobotDeath(RobotDeathEvent e){
		for(int i=0;i<enemies.size();i++){
			Enemy currentEnemy = (Enemy)enemies.get(i);
			if(currentEnemy.name.equals(e.getName())){
				enemies.remove(i);
			}
		}
		if(currentlyShootingAt != null){
			if(currentlyShootingAt.name.equals(e.getName())){
				currentlyShootingAt = null;
			}
		}
	}
	
	//********************************
	//Fire
	//********************************
	public void doFire(Enemy e){
		//firepower calculation
		double power = 3;
//		double power = e.distance/75 + 11/3;
//		if(power>3){
//			power = 3;
//		}else if(power<0.1){
//			power = 0.1;
//		}
		
		double avgTurnrate = averageTurnrate(10, e);
		
		//Your current position.
		double x = getX();
		double y = getY();
		
		double enemyNewX = e.x;
		double enemyNewY = e.y;
		double newDistance = e.distance;
		
		if(e.timesScanned > 2){
			for(int i = 0; i < 10; i++){
				newDistance = Math.sqrt( Math.pow(x-enemyNewX, 2) + Math.pow(y-enemyNewY, 2) );
				double time = newDistance/getBulletSpeed(power);
				if(Math.abs(e.turnrate.get(e.turnrate.size() - 1)) > 0.0001){
					enemyNewX = (e.avgVelocity/avgTurnrate) * (Math.cos(e.heading) - Math.cos(e.heading + avgTurnrate*time)) + e.x;
					enemyNewY = (e.avgVelocity/avgTurnrate) * (Math.sin(e.heading + avgTurnrate*time) - Math.sin(e.heading)) + e.y;
				} else {
					enemyNewX = e.x + Math.sin(e.heading)*e.velocity*time;
					enemyNewY = e.y + Math.cos(e.heading)*e.velocity*time;
				}
			}
		}
		

		
		double newAngle;
		if(enemyNewY > y) {
			newAngle = Math.asin((enemyNewX-x)/newDistance);
		} else {
			newAngle = Math.PI - Math.asin((enemyNewX-x)/newDistance);
		}
		
		double gunTurnAngle = getRelativeAngle(getGunHeadingRadians() - newAngle);

		setTurnGunLeftRadians(gunTurnAngle);
		
		setFire(power);
	}
	
	
	//********************************
	//Scanner
	//********************************
	public void doScanner(){
		
		timeSinceLastScan++;
		
		if(timeSinceLastScan > 4 || getOthers() > 1) {
			setTurnRadarLeftRadians(2*Math.PI);
		} else {
			double radarError = getRelativeAngle(getRadarHeadingRadians() - enemyAbsoluteBearing);
			if(radarError < 0) {
				radarError -= Math.PI/8;
			} else {
				radarError += Math.PI/8;
			}
			setTurnRadarLeftRadians(getRelativeAngle(radarError));
		}
	}
	
	//********************************
	//Remove the bullet if neccesary
	//********************************
	public void checkBullets(){
		for(int i=0;i<bullets.size();i++){
			if(((EnemyBullet)bullets.get(i)).passedMe(getTime()) ){
				bullets.remove(i);
			}
		}
	}
	
	
	//********************************
	//Calculate the best direction to move
	//********************************
	public double calculateDirection(){
		double enemyGravityX = 0;
		double enemyGravityY = 0;
		
		double bulletGravityY = 0;
		double bulletGravityX = 0;
		
		if(bullets.size() != 0){
			for(int i = 0; i< bullets.size(); i++){
				EnemyBullet b = (EnemyBullet)bullets.get(i);
				bulletGravityX += 2*(b.yDist/b.xDist)/Math.pow((b.yDist*(getX() - b.xFiredFrom)/b.xDist), 3);
				bulletGravityY -= 2/Math.pow((b.yDist*(getX() - b.xFiredFrom)/b.xDist), 3);
			}
			bulletGravityX /= bullets.size();
			bulletGravityY /= bullets.size();
		}
		

		
		for(int i = 0; i< enemies.size(); i++){
			Enemy currentEnemy = (Enemy)enemies.get(i);
			double squareDistanceToEnemy = Math.pow( getX()-currentEnemy.x , 2) + Math.pow( getY()-currentEnemy.y , 2);
			enemyGravityX += 2*(getX()-currentEnemy.x)/Math.pow(squareDistanceToEnemy, 2);
			enemyGravityY += 2*(getY()-currentEnemy.y)/Math.pow(squareDistanceToEnemy, 2);
		}
		
		double wallX = -2/(Math.pow( ( getBattleFieldWidth()-getX() ) , 3 ) ) + 2/(Math.pow( getX() , 3 ) );
		double wallY = -2/(Math.pow( ( getBattleFieldHeight()-getY() ) , 3 ) ) + 2/(Math.pow( getY() , 3 ) );
		
		double bestX = enemyGravityX + bulletGravityX + wallX;
		double bestY = enemyGravityY + bulletGravityY + wallY;
		
//		double bestX = wallX;
//		double bestY = wallY;
		
//		double bestX = bulletGravityX;
//		double bestY = bulletGravityY;
		
//		double bestX = wallX + enemyGravityX;
//		double bestY = wallY + enemyGravityY;
		
//		out.println(wallX + " " + bulletGravityX + " " + enemyGravityX);
//		out.println(wallY + " " + bulletGravityY + " " + enemyGravityY);
//		out.println("");
		
		double absoluteBestAngle;
		if(bestY >= 0){
			absoluteBestAngle = Math.atan(bestX/bestY);
		} else {
			absoluteBestAngle = PI + Math.atan(bestX/bestY);
		}
		return absoluteBestAngle;
		
	}
	
	
	//********************************
	//sets the angle between -Pi and Pi
	//********************************
	public double getRelativeAngle(double angle) {
		while(angle > Math.PI) {
			angle -= 2*Math.PI;
		}
		while(angle < -Math.PI) {
			angle += 2*Math.PI;
		}
		return angle;
	}
	
	//********************************
	//Calculates the speed of the bullet
	//********************************
	public double getBulletSpeed(double power) {
		return 20-power*3;
	}
	//********************************
	//Find average turnrate of last scans
	//********************************
	
	public double averageTurnrate(int numTimes, Enemy e){
		int last = e.turnrate.size() - 1;
		if(numTimes > e.turnrate.size()){
			numTimes = e.turnrate.size();
		}
		double sum = 0;
		for(int i = last ; i > last - numTimes; i--){
			sum += e.turnrate.get(i);
		}
		sum /= numTimes;
		return sum;
	}
}
