package com.timothyveletta;

import com.timothyveletta.states.*;

public class AIControl {
	private FuzzyBot bot;
	private StateMachine machine;
	
	public enum Wall {LEFT, RIGHT, TOP, BOTTOM};
	
	// PERCEPTIONS
	public static double nearestEnemyDist;
	public static double nearestWallDist;
	public static Wall closestWall;
	public static double energy;
	
	public AIControl(FuzzyBot bot) {
		this.bot = bot;
		machine = new StateMachine(this.bot);
		
		machine.AddState(new ApproachEnemyState(bot));
		machine.AddState(new AttackState(bot));
		machine.AddState(new AvoidEnemy(bot));
		machine.AddState(new AvoidWall(bot));
		machine.AddState(new PanicState(bot));
		
		nearestEnemyDist = -1.0;
		nearestWallDist = -1.0;
		energy = 0.0;
	}
	
	public void Init() {
		machine.Init();
	}

	public void Update() {
		UpdatePerceptions();
		
		machine.UpdateMachine();
	}
	
	private void UpdatePerceptions() {
		nearestEnemyDist = bot.enemyDist;
		
		energy = bot.getEnergy();

		FindClosestWall();
	}
	
	private void FindClosestWall() {
		double distFromTop = bot.battleFieldHeight - bot.myY;
		double distFromBottom = bot.myY;
		double distFromLeft =  bot.myX;
		double distFromRight = bot.battleFieldWidth - bot.myX;
		
		if(IsSmallest(distFromTop, distFromBottom, distFromLeft, distFromRight)) {
			nearestWallDist = distFromTop;
			closestWall = Wall.TOP;
		} else if(IsSmallest(distFromBottom, distFromTop, distFromLeft, distFromRight)) {
			nearestWallDist = distFromBottom;
			closestWall = Wall.BOTTOM;
		} else if(IsSmallest(distFromLeft, distFromBottom, distFromTop, distFromRight)) {
			nearestWallDist = distFromLeft;
			closestWall = Wall.LEFT;
		} else if(IsSmallest(distFromRight, distFromBottom, distFromTop, distFromLeft)) {
			nearestWallDist = distFromRight;
			closestWall = Wall.RIGHT;
		}
	}
	
	private boolean IsSmallest(double in, double compare1, double compare2, double compare3) {
		return in < compare1 && in < compare2 && in < compare3;
	}
}
