package m3thos;
import robocode.*;
import java.util.*;
import java.io.*;

/**
 * Memory.java
 * This is the Memory of Eva, serve has logger and recorder of other robots
 * And other usefull information that can be used by Eva in future runs.
 *
 * @author Miguel Sousa Filipe (m3thos)
 * Created on 13 de Janeiro de 2003, 2:08
 */
public class Memory implements Serializable
{
    private HashMap _globalEnemyMap = new HashMap();
    private File file;

    /**
     * On creation one should check for logged records of allready known bots
     *  that are present in the current battle, load this records into mem
     * and prepare them to make them available to Eva.
     */
    public Memory(File f)
    {
        file = f;
        getMemory();
    }

    public Enemy getEnemy(String name)
    {
        Enemy enemy = (Enemy) _globalEnemyMap.get(name);
        if( enemy == null)
            enemy = new Enemy(name);
        enemy.printFightStats();
        return enemy;
    }

    /* remember allways supercedes current memory entries */
    public void remmember(Enemy e)
    {
        if(e.getName().equals("_null_"))
            return;
        _globalEnemyMap.put(e.getName(),e);
    }

    public void remmemberAll(Collection enemies)
    {
        Iterator iterador = enemies.iterator();
        Enemy enemy;
        while( iterador.hasNext() )
        {
            enemy = (Enemy) iterador.next();
            remmember(enemy);
        }
    }

    /**
     * preserveMemory
     * preserves Memory data bank saving it to disk.
     */
    public void preserveMemory()
    {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new RobocodeFileOutputStream(file));
            out.writeObject(_globalEnemyMap);
            out.close();
        } catch (IOException e) {
            System.err.println("IOException trying to write memory data bank: " + e.getMessage());
        }
    }

    /**
     * getMemory
     * gets memory data bank from disk.
     */
    public void getMemory()
    {
        try
        {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            
            HashMap map  = (HashMap) in.readObject();
            Iterator iter = map.values().iterator();
            System.out.println("Memory, list of known enemies:");
            while(iter.hasNext())
            {
                Enemy e = (Enemy) iter.next();
                remmember(e);
            }
            in.close();
        } catch(FileNotFoundException fnfe)
        {
            System.out.println("Memory.getMemory(): File not found, no problem, will go without one.\n for the record the error was: "+fnfe.getMessage());

        } catch(IOException e)
        {
            System.out.println("Memory.getMemory(): IOExeption occured trying to read memory data bank from disk :"+ e.getMessage());
        } catch(ClassNotFoundException cfne)
        {
            System.out.println("Memory.getMemory(): ClassNotFoundException occured trying to read memory data bank from disk :"+cfne.getMessage());
        }
    }
}
