package fromHell.utils;

import robocode.*;
import java.awt.geom.*;

public final class FHUtils {
    public static final double BOT_WIDTH = 36;
    public static final double WALL_MARGIN = BOT_WIDTH / 2;
    public static final double NARROW_RADARLOCK_MULTIPLIER = 2;
    public static final int ACCELERATION_RATE = 1;
    public static final int DECELERATION_RATE = 2;

    public static Point2D.Double project(Point2D sourceLocation, double angle, double length) {
	return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D source, Point2D target) {
	return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public static int sign(double value) {
	return value < 0 ? -1 : 1;
    }

    public static double minMax(double value, double min, double max) {
	return Math.max(min, Math.min(max, value));
    }

    public static double minMax(double value, double max) {
	return minMax(value, -max, max);
    }

    public static double rollingAvg(double value, double newEntry, double n) {
	return (value * n + newEntry) / (n + 1.0);
    }

    public static double maxEscapeAngle(double velocity) {
	return Math.asin(Rules.MAX_VELOCITY / velocity);
    }

    public static Rectangle2D getBattlefieldRectangle(AdvancedRobot robot) {
	return new Rectangle2D.Double(WALL_MARGIN, WALL_MARGIN, robot.getBattleFieldWidth() - WALL_MARGIN * 2, robot.getBattleFieldHeight() - WALL_MARGIN * 2);
    }

    public static double bulletVelocity(double bulletPower) {
	return 20 - 3 * bulletPower;
    }

    public static int getVelocityIndex(double velocity) {
	return (int) Math.abs(velocity / 2);
    }

    public static int index(double[] slices, double value) {
	for (int i = 0; i < slices.length; i++) {
	    if (value < slices[i]) {
		return i;
	    }
	}
	return slices.length;
    }

    public static double botWidthAngle(double distance) {
	return Math.atan2(BOT_WIDTH, distance);
    }
}
