package djc;
import robocode.*;

/**
 * JiggleTargetingStrategy.  Based on JollyNinja
 */
public class JiggleTargetingStrategy extends TargetingStrategy
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */
    
    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */
    JiggleAnalyser ja = null;

    JiggleTargetingStrategy(Target pT, JiggleAnalyser jiggleAnalyser)
    {
        super(pT);
	ja = jiggleAnalyser;
        name = TargetingStrategyManager.JIGGLE;
    }

    /**
     * predictCoordinates
     * <br>
     *
     *  @return Coordinate
     */
    public Coordinate predictCoordinate(double curTime, double futureTime)
    {
	return ja.getEstimatedPosition(futureTime);
    }

}
