package djc;
import robocode.*;

/**
 * TargetingStrategy.  
 */
public abstract class TargetingStrategy
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */
    public Target t;
    public String name;
    public double shotsFired = 0.0;
    public double timesHit = 0.0;

    // Constructor; set up the TargetingStrategy class.
    public TargetingStrategy (Target pT)
    {
         t = pT;
         name = "None";
    }

    /**
     * predictCoordinates
     *  @return Coordinate
     */
    public abstract Coordinate predictCoordinate(double curTime, double futureTime);

    public double getFitness()
    {
	if(shotsFired < 1) return 1.0;
	else return timesHit / shotsFired;
    }

}
